<?php

if ( !function_exists('tonda_select_register_required_plugins') ) {
	/**
	 * Registers theme required and optional plugins. Hooks to tgmpa_register hook
	 */
	function tonda_select_register_required_plugins() {
		$plugins = array(
			array(
				'name'               => esc_html__('WPBakery Page Builder', 'tonda'),
				'slug'               => 'js_composer',
				'source'             => get_template_directory() . '/includes/plugins/js_composer.zip',
				'version'            => '6.3.0',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__('Revolution Slider', 'tonda'),
				'slug'               => 'revslider',
				'source'             => get_template_directory() . '/includes/plugins/revslider.zip',
				'version'            => '6.2.22',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__('Tonda Core', 'tonda'),
				'slug'               => 'tonda-core',
				'source'             => get_template_directory() . '/includes/plugins/tonda-core.zip',
				'version'            => '1.4.1',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__('Tonda Membership', 'tonda'),
				'slug'               => 'tonda-membership',
				'source'             => get_template_directory() . '/includes/plugins/tonda-membership.zip',
				'version'            => '1.0.1',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__('Tonda Instagram Feed', 'tonda'),
				'slug'               => 'tonda-instagram-feed',
				'source'             => get_template_directory() . '/includes/plugins/tonda-instagram-feed.zip',
				'version'            => '1.0.2',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__('Tonda Twitter Feed', 'tonda'),
				'slug'               => 'tonda-twitter-feed',
				'source'             => get_template_directory() . '/includes/plugins/tonda-twitter-feed.zip',
				'version'            => '1.0.2',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'     => esc_html__('WooCommerce', 'tonda'),
				'slug'     => 'woocommerce',
				'required' => true
			),
			array(
				'name'     => esc_html__('YITH WooCommerce Wishlist', 'tonda'),
				'slug'     => 'yith-woocommerce-wishlist',
				'required' => true
			),
			array(
				'name'     => esc_html__('YITH WooCommerce Quick View', 'tonda'),
				'slug'     => 'yith-woocommerce-quick-view',
				'required' => true
			),
			array(
				'name'     => esc_html__('Contact Form 7', 'tonda'),
				'slug'     => 'contact-form-7',
				'required' => false
			),
			array(
				'name'     => esc_html__( 'Envato Market', 'tonda' ),
				'slug'     => 'envato-market',
				'source'   => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
				'required' => false,
			)
		);
		
		$config = array(
			'domain'       => 'tonda',
			'default_path' => '',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'menu'         => 'install-required-plugins',
			'has_notices'  => true,
			'is_automatic' => false,
			'message'      => '',
			'strings'      => array(
				'page_title'                      => esc_html__('Install Required Plugins', 'tonda'),
				'menu_title'                      => esc_html__('Install Plugins', 'tonda'),
				'installing'                      => esc_html__('Installing Plugin: %s', 'tonda'),
				'oops'                            => esc_html__('Something went wrong with the plugin API.', 'tonda'),
				'notice_can_install_required'     => _n_noop('This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'tonda'),
				'notice_can_install_recommended'  => _n_noop('This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'tonda'),
				'notice_cannot_install'           => _n_noop('Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'tonda'),
				'notice_can_activate_required'    => _n_noop('The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'tonda'),
				'notice_can_activate_recommended' => _n_noop('The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'tonda'),
				'notice_cannot_activate'          => _n_noop('Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'tonda'),
				'notice_ask_to_update'            => _n_noop('The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'tonda'),
				'notice_cannot_update'            => _n_noop('Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'tonda'),
				'install_link'                    => _n_noop('Begin installing plugin', 'Begin installing plugins', 'tonda'),
				'activate_link'                   => _n_noop('Activate installed plugin', 'Activate installed plugins', 'tonda'),
				'return'                          => esc_html__('Return to Required Plugins Installer', 'tonda'),
				'plugin_activated'                => esc_html__('Plugin activated successfully.', 'tonda'),
				'complete'                        => esc_html__('All plugins installed and activated successfully. %s', 'tonda'),
				'nag_type'                        => 'updated'
			)
		);
		
		tgmpa($plugins, $config);
	}
	
	add_action('tgmpa_register', 'tonda_select_register_required_plugins');
}