<?php
$product = tonda_select_return_woocommerce_global_variable();

if ( $display_sale_mark == 'yes' ) {
	
	if ( $product->is_on_sale() ) { ?>
		<span class="qodef-<?php echo esc_attr( $class_name ); ?>-onsale"><?php echo tonda_select_woocommerce_sale_percentage( $product ); ?></span>
	<?php } ?>
	
	<?php if ( ! $product->is_in_stock() ) { ?>
		<span class="qodef-<?php echo esc_attr( $class_name ); ?>-out-of-stock"><?php esc_html_e( 'Sold', 'tonda' ); ?></span>
	<?php }
	
	$new = get_post_meta( get_the_ID(), 'qodef_show_new_sign_woo_meta', true );
	
	if ( $new === 'yes' ) { ?>
		<span class="qodef-<?php echo esc_attr( $class_name ); ?>-new-product"><?php esc_html_e( 'New', 'tonda' ); ?></span>
	<?php }
}

$product_image_size = 'woocommerce_single';
if ( $image_size === 'full' ) {
	$product_image_size = 'full';
} else if ( $image_size === 'square' ) {
	$product_image_size = 'tonda_select_image_square';
} else if ( $image_size === 'landscape' ) {
	$product_image_size = 'tonda_select_image_landscape';
} else if ( $image_size === 'portrait' ) {
	$product_image_size = 'tonda_select_image_portrait';
} else if ( $image_size === 'medium' ) {
	$product_image_size = 'medium';
} else if ( $image_size === 'large' ) {
	$product_image_size = 'large';
} else if ( $image_size === 'woocommerce_thumbnail' ) {
	$product_image_size = 'woocommerce_thumbnail';
}

if ( has_post_thumbnail() ) { ?>
	
	<div class="qodef-woo-pli-images qodef-woo-pli-slider">
		<a href="<?php echo get_the_permalink(); ?>">
			<?php the_post_thumbnail( 'full' ); ?>
		</a>
		<?php
		$image_ids = explode( ',', get_post_meta( get_the_ID(), 'qodef-woocommerce-image-gallery', true ) );
		foreach ( $image_ids as $image ) { ?>
			<a href="<?php echo get_the_permalink(); ?>">
				<?php echo wp_get_attachment_image( $image, 'full' ); ?>
			</a>
		<?php }
		?>
	</div>

<?php }