<?php

namespace TondaCore\CPT\Shortcodes\ProductList;

use TondaCore\Lib;

class ProductList implements Lib\ShortcodeInterface {
	private $base;
	private $dependencyOptions;
	
	function __construct() {
		$this->base = 'qodef_product_list';
		
		$this->dependencyOptions = array();
		
		if ( tonda_select_is_yith_clv_installed() ) {
			
			$this->dependencyOptions[] = array(
				'type'        => 'dropdown',
				'param_name'  => 'enable_variations',
				'heading'     => esc_html__( 'Enable Variations Selector', 'tonda' ),
				'value'       => array_flip( tonda_select_get_yes_no_select_array( false ) ),
				'group'       => esc_html__( 'Product Info', 'tonda' )
			);
			
		}
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Product List', 'tonda' ),
					'base'                      => $this->base,
					'icon'                      => 'icon-wpb-product-list extended-custom-icon',
					'category'                  => esc_html__( 'by TONDA', 'tonda' ),
					'allowed_container_element' => 'vc_row',
					'params'                    => array_merge(
                        array(
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'type',
                                'heading'     => esc_html__( 'Type', 'tonda' ),
                                'value'       => array(
                                    esc_html__( 'Standard', 'tonda' ) => 'standard',
                                    esc_html__( 'Masonry', 'tonda' )  => 'masonry'
                                ),
                                'admin_label' => true
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'info_position',
                                'heading'     => esc_html__( 'Product Info Position', 'tonda' ),
                                'value'       => array(
                                    esc_html__( 'Info Below Image', 'tonda' )    => 'info-below-image',
                                    esc_html__( 'Info On Image Hover', 'tonda' ) => 'info-on-image'
                                ),
                                'save_always' => true
                            ),
                            array(
                                'type'       => 'textfield',
                                'param_name' => 'number_of_posts',
                                'heading'    => esc_html__( 'Number of Products', 'tonda' )
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'number_of_columns',
                                'heading'     => esc_html__( 'Number of Columns', 'tonda' ),
                                'value'       => array(
                                    esc_html__( 'One', 'tonda' )   => '1',
                                    esc_html__( 'Two', 'tonda' )   => '2',
                                    esc_html__( 'Three', 'tonda' ) => '3',
                                    esc_html__( 'Four', 'tonda' )  => '4',
                                    esc_html__( 'Five', 'tonda' )  => '5',
                                    esc_html__( 'Six', 'tonda' )   => '6'
                                ),
                                'save_always' => true
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'space_between_items',
                                'heading'     => esc_html__( 'Space Between Items', 'tonda' ),
                                'value'       => array_flip( tonda_select_get_space_between_items_array(false, true, true, true , true) ),
                                'save_always' => true
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'orderby',
                                'heading'     => esc_html__( 'Order By', 'tonda' ),
                                'value'       => array_flip( tonda_select_get_query_order_by_array( false, array( 'on-sale' => esc_html__( 'On Sale', 'tonda' ) ) ) ),
                                'save_always' => true
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'order',
                                'heading'     => esc_html__( 'Order', 'tonda' ),
                                'value'       => array_flip( tonda_select_get_query_order_array() ),
                                'save_always' => true
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'taxonomy_to_display',
                                'heading'     => esc_html__( 'Choose Sorting Taxonomy', 'tonda' ),
                                'value'       => array(
                                    esc_html__( 'Category', 'tonda' ) => 'category',
                                    esc_html__( 'Tag', 'tonda' )      => 'tag',
                                    esc_html__( 'Id', 'tonda' )       => 'id'
                                ),
                                'save_always' => true,
                                'description' => esc_html__( 'If you would like to display only certain products, this is where you can select the criteria by which you would like to choose which products to display', 'tonda' )
                            ),
                            array(
                                'type'        => 'textfield',
                                'param_name'  => 'taxonomy_values',
                                'heading'     => esc_html__( 'Enter Taxonomy Values', 'tonda' ),
                                'description' => esc_html__( 'Separate values (category slugs, tags, or post IDs) with a comma', 'tonda' )
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'image_size',
                                'heading'    => esc_html__( 'Image Proportions', 'tonda' ),
                                'value'      => array(
                                    esc_html__( 'Default', 'tonda' )        => '',
                                    esc_html__( 'Original', 'tonda' )       => 'full',
                                    esc_html__( 'Square', 'tonda' )         => 'square',
                                    esc_html__( 'Landscape', 'tonda' )      => 'landscape',
                                    esc_html__( 'Portrait', 'tonda' )       => 'portrait',
                                    esc_html__( 'Medium', 'tonda' )         => 'medium',
                                    esc_html__( 'Large', 'tonda' )          => 'large',
                                    esc_html__( 'Shop Single', 'tonda' )    => 'woocommerce_single',
                                    esc_html__( 'Shop Thumbnail', 'tonda' ) => 'woocommerce_thumbnail'
                                ),
                                'dependency' => array( 'element' => 'type', 'value' => array( 'standard' ) ),
                                'save_always' => true
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'display_title',
                                'heading'    => esc_html__( 'Display Title', 'tonda' ),
                                'value'      => array_flip( tonda_select_get_yes_no_select_array( false, true ) ),
                                'group'      => esc_html__( 'Product Info', 'tonda' )
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'product_info_skin',
                                'heading'    => esc_html__( 'Product Info Skin', 'tonda' ),
                                'value'      => array(
                                    esc_html__( 'Default', 'tonda' ) => 'default',
                                    esc_html__( 'Light', 'tonda' )   => 'light',
                                    esc_html__( 'Dark', 'tonda' )    => 'dark'
                                ),
                                'dependency' => array( 'element' => 'info_position', 'value' => array( 'info-on-image' ) ),
                                'group'      => esc_html__( 'Product Info Style', 'tonda' )
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'title_tag',
                                'heading'    => esc_html__( 'Title Tag', 'tonda' ),
                                'value'      => array_flip( tonda_select_get_title_tag( true ) ),
                                'dependency' => array( 'element' => 'display_title', 'value' => array( 'yes' ) ),
                                'group'      => esc_html__( 'Product Info Style', 'tonda' )
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'title_transform',
                                'heading'    => esc_html__( 'Title Text Transform', 'tonda' ),
                                'value'      => array_flip( tonda_select_get_text_transform_array( true ) ),
                                'dependency' => array( 'element' => 'display_title', 'value' => array( 'yes' ) ),
                                'group'      => esc_html__( 'Product Info Style', 'tonda' )
                            )
                        ),
                        $this->dependencyOptions,
                        array(
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'display_category',
                                'heading'    => esc_html__( 'Display Category', 'tonda' ),
                                'value'      => array_flip( tonda_select_get_yes_no_select_array( false, true ) ),
                                'group'      => esc_html__( 'Product Info', 'tonda' )
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'display_price',
                                'heading'    => esc_html__( 'Display Price', 'tonda' ),
                                'value'      => array_flip( tonda_select_get_yes_no_select_array( false, true ) ),
                                'group'      => esc_html__( 'Product Info', 'tonda' )
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'display_sale_mark',
                                'heading'    => esc_html__( 'Display Sale Mark', 'tonda' ),
                                'value'      => array_flip( tonda_select_get_yes_no_select_array( false, true ) ),
                                'group'      => esc_html__( 'Product Info', 'tonda' )
                            ),
                            array(
                                'type'       => 'colorpicker',
                                'param_name' => 'shader_background_color',
                                'heading'    => esc_html__( 'Shader Background Color', 'tonda' ),
                                'group'      => esc_html__( 'Product Info Style', 'tonda' )
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'info_bottom_text_align',
                                'heading'    => esc_html__( 'Product Info Text Alignment', 'tonda' ),
                                'value'      => array(
                                    esc_html__( 'Default', 'tonda' ) => '',
                                    esc_html__( 'Left', 'tonda' )    => 'left',
                                    esc_html__( 'Center', 'tonda' )  => 'center',
                                    esc_html__( 'Right', 'tonda' )   => 'right'
                                ),
                                'dependency' => array( 'element' => 'info_position', 'value'   => array( 'info-below-image' ) ),
                                'group'      => esc_html__( 'Product Info Style', 'tonda' )
                            ),
                            array(
                                'type'       => 'textfield',
                                'param_name' => 'info_bottom_margin',
                                'heading'    => esc_html__( 'Product Info Bottom Margin (px)', 'tonda' ),
                                'dependency' => array( 'element' => 'info_position', 'value'   => array( 'info-below-image' ) ),
                                'group'      => esc_html__( 'Product Info Style', 'tonda' )
                            )
                        )
                    )
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$default_atts = array(
			'type'                    => 'standard',
			'info_position'           => 'info-below-image',
			'number_of_posts'         => '8',
			'number_of_columns'       => '4',
			'space_between_items'     => 'normal',
			'orderby'                 => 'date',
			'order'                   => 'ASC',
			'taxonomy_to_display'     => 'category',
			'taxonomy_values'         => '',
			'image_size'              => 'full',
			'display_title'           => 'yes',
			'product_info_skin'       => '',
			'title_tag'               => 'h4',
			'title_transform'         => '',
			'display_category'        => 'yes',
			'display_price'           => 'yes',
			'display_button'          => 'yes',
			'shader_background_color' => '',
			'info_bottom_text_align'  => '',
			'info_bottom_margin'      => '',
            'enable_variations'       => 'no',
            'display_sale_mark'       => 'yes'
		);
		$params       = shortcode_atts( $default_atts, $atts );
		
		$params['class_name']     = 'pli';
		$params['type']           = ! empty( $params['type'] ) ? $params['type'] : $default_atts['type'];
		$params['info_position']  = ! empty( $params['info_position'] ) ? $params['info_position'] : $default_atts['info_position'];
		$params['title_tag']      = ! empty( $params['title_tag'] ) ? $params['title_tag'] : $default_atts['title_tag'];
		
		$additional_params                   = array();
		$additional_params['holder_classes'] = $this->getHolderClasses( $params, $default_atts );
		
		$queryArray                        = $this->generateProductQueryArray( $params );
		$query_result                      = new \WP_Query( $queryArray );
		$additional_params['query_result'] = $query_result;
		
		$params['this_object'] = $this;
		
		$html = tonda_select_get_woo_shortcode_module_template_part( 'templates/product-list', 'product-list', $params['type'], $params, $additional_params );
		
		return $html;
	}
	
	private function getHolderClasses( $params, $default_atts ) {
		$holderClasses   = array();
		$holderClasses[] = ! empty( $params['type'] ) ? 'qodef-' . $params['type'] . '-layout' : 'qodef-' . $default_atts['type'] . '-layout';
		$holderClasses[] = ! empty( $params['space_between_items'] ) ? 'qodef-' . $params['space_between_items'] . '-space' : 'qodef-' . $default_atts['space_between_items'] . '-space';
		$holderClasses[] = $this->getColumnNumberClass( $params );
		$holderClasses[] = ! empty( $params['info_position'] ) ? 'qodef-' . $params['info_position'] : 'qodef-' . $default_atts['info_position'];
		$holderClasses[] = ! empty( $params['product_info_skin'] ) ? 'qodef-product-info-' . $params['product_info_skin'] : '';
		
		return implode( ' ', $holderClasses );
	}
	
	private function getColumnNumberClass( $params ) {
		$columnsNumber = '';
		$columns       = $params['number_of_columns'];
		
		switch ( $columns ) {
			case 1:
				$columnsNumber = 'qodef-one-column';
				break;
			case 2:
				$columnsNumber = 'qodef-two-columns';
				break;
			case 3:
				$columnsNumber = 'qodef-three-columns';
				break;
			case 4:
				$columnsNumber = 'qodef-four-columns';
				break;
			case 5:
				$columnsNumber = 'qodef-five-columns';
				break;
			case 6:
				$columnsNumber = 'qodef-six-columns';
				break;
			default:
				$columnsNumber = 'qodef-four-columns';
				break;
		}
		
		return $columnsNumber;
	}
	
	private function generateProductQueryArray( $params ) {
		$queryArray = array(
			'post_status'         => 'publish',
			'post_type'           => 'product',
			'ignore_sticky_posts' => 1,
			'posts_per_page'      => $params['number_of_posts'],
			'orderby'             => $params['orderby'],
			'order'               => $params['order']
		);
		
		if ( $params['orderby'] === 'on-sale' ) {
			$queryArray['no_found_rows'] = 1;
			$queryArray['post__in']      = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
		}
		
		if ( $params['taxonomy_to_display'] !== '' && $params['taxonomy_to_display'] === 'category' ) {
			$queryArray['product_cat'] = $params['taxonomy_values'];
		}
		
		if ( $params['taxonomy_to_display'] !== '' && $params['taxonomy_to_display'] === 'tag' ) {
			$queryArray['product_tag'] = $params['taxonomy_values'];
		}
		
		if ( $params['taxonomy_to_display'] !== '' && $params['taxonomy_to_display'] === 'id' ) {
			$idArray                = $params['taxonomy_values'];
			$ids                    = explode( ',', $idArray );
            $queryArray['orderby'] = 'post__in';
			$queryArray['post__in'] = $ids;
		}
		
		return $queryArray;
	}
	
	public function getItemClasses( $params ) {
		global $product;
		$itemClasses = array();
		
		$image_size_meta = get_post_meta( get_the_ID(), 'qodef_product_featured_image_size', true );
		
		if ( ! empty( $image_size_meta ) ) {
			$itemClasses[] = 'qodef-woo-fixed-masonry qodef-masonry-size-' . $image_size_meta;
		}
		
		if ( ! $product->is_in_stock() ) {
			$itemClasses[] = 'qodef-pli-outofstock';
		}
		
		return implode( ' ', $itemClasses );
	}
	
	public function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_transform'] ) ) {
			$styles[] = 'text-transform: ' . $params['title_transform'];
		}
		
		return implode( ';', $styles );
	}
	
	public function getShaderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['shader_background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['shader_background_color'];
		}
		
		return implode( ';', $styles );
	}
	
	public function getTextWrapperStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['info_bottom_text_align'] ) ) {
			$styles[] = 'text-align: ' . $params['info_bottom_text_align'];
		}
		
		if ( $params['info_bottom_margin'] !== '' ) {
			$styles[] = 'margin-bottom: ' . tonda_select_filter_px( $params['info_bottom_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}
}