<?php

namespace TondaCore\CPT\Shortcodes\ProductCategoryList;

use TondaCore\Lib;

class ProductCategoryList implements Lib\ShortcodeInterface {
	private $base;

	function __construct() {
		$this->base = 'qodef_product_category_list';

		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Product Category List', 'tonda' ),
					'base'                      => $this->base,
					'icon'                      => 'icon-wpb-product-category-list extended-custom-icon',
					'category'                  => esc_html__( 'by TONDA', 'tonda' ),
					'allowed_container_element' => 'vc_row',
					'params'                    => array_merge(
                        array(
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'type',
                                'heading'     => esc_html__( 'Type', 'tonda' ),
                                'value'       => array(
                                    esc_html__( 'Standard', 'tonda' ) => 'standard',
                                    esc_html__( 'Masonry', 'tonda' )  => 'masonry'
                                ),
                                'admin_label' => true
                            ),
                            array(
                                'type'       => 'textfield',
                                'param_name' => 'number_of_posts',
                                'heading'    => esc_html__( 'Number of Product Categories', 'tonda' )
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'number_of_columns',
                                'heading'     => esc_html__( 'Number of Columns', 'tonda' ),
                                'value'       => array(
                                    esc_html__( 'One', 'tonda' )   => '1',
                                    esc_html__( 'Two', 'tonda' )   => '2',
                                    esc_html__( 'Three', 'tonda' ) => '3',
                                    esc_html__( 'Four', 'tonda' )  => '4',
                                    esc_html__( 'Five', 'tonda' )  => '5',
                                    esc_html__( 'Six', 'tonda' )   => '6'
                                ),
                                'save_always' => true
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'space_between_items',
                                'heading'     => esc_html__( 'Space Between Items', 'tonda' ),
                                'value'       => array_flip( tonda_select_get_space_between_items_array() ),
                                'save_always' => true
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'orderby',
                                'heading'     => esc_html__( 'Order By', 'tonda' ),
                                'value'       => array_flip( tonda_select_get_query_order_by_array( false, array( 'on-sale' => esc_html__( 'On Sale', 'tonda' ) ) ) ),
                                'save_always' => true
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'order',
                                'heading'     => esc_html__( 'Order', 'tonda' ),
                                'value'       => array_flip( tonda_select_get_query_order_array() ),
                                'save_always' => true
                            ),
                            array(
                                'type'       => 'textfield',
                                'param_name' => 'category_slugs',
                                'heading'    => esc_html__( 'Enter the category slugs you want to display, separated by commas (leave empty for showing all categories)', 'tonda' )
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'image_size',
                                'heading'    => esc_html__( 'Image Proportions', 'tonda' ),
                                'value'      => array(
                                    esc_html__( 'Default', 'tonda' )        => '',
                                    esc_html__( 'Original', 'tonda' )       => 'full',
                                    esc_html__( 'Square', 'tonda' )         => 'tonda_select_image_square',
                                    esc_html__( 'Landscape', 'tonda' )      => 'tonda_select_image_landscape',
                                    esc_html__( 'Portrait', 'tonda' )       => 'tonda_select_image_portrait',
                                    esc_html__( 'Medium', 'tonda' )         => 'medium',
                                    esc_html__( 'Large', 'tonda' )          => 'large',
                                    esc_html__( 'Shop Single', 'tonda' )    => 'woocommerce_single',
                                    esc_html__( 'Shop Thumbnail', 'tonda' ) => 'woocommerce_thumbnail'
                                ),
                                'dependency' => array( 'element' => 'type', 'value' => array( 'standard' ) ),
                                'save_always' => true
                            )
                        )
                    )
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$default_atts = array(
			'type'                       => 'standard',
			'number_of_posts'            => '8',
			'number_of_columns'          => '4',
			'space_between_items'        => 'normal',
			'orderby'                    => 'date',
			'order'                      => 'ASC',
			'category_slugs'             => '',
			'image_size'                 => 'full'
		);
		$params       = shortcode_atts( $default_atts, $atts );

		$params['category_slugs'] = trim( $params['category_slugs'] );
		if ( empty( $params['category_slugs'] ) ) {
			$params['category_slugs'] = array();
		} else {
			$params['category_slugs'] = explode( ',', str_replace( ' ', '', $params['category_slugs'] ) );
		}

		$additional_params                   = array();
		$additional_params['holder_classes'] = $this->getHolderClasses( $params, $default_atts );
		$additional_params['query_result']   = $this->generateProductCategoryQueryArray( $params );
		
		$params['this_object'] = $this;
		
		$html = tonda_select_get_woo_shortcode_module_template_part( 'templates/product-category-list', 'product-category-list', '', $params, $additional_params );
		
		return $html;
	}
	
	private function getHolderClasses( $params, $default_atts ) {
		$holderClasses   = array();
		$holderClasses[] = ! empty( $params['type'] ) ? 'qodef-' . $params['type'] . '-layout' : 'qodef-' . $default_atts['type'] . '-layout';
		$holderClasses[] = ! empty( $params['space_between_items'] ) ? 'qodef-' . $params['space_between_items'] . '-space' : 'qodef-' . $default_atts['space_between_items'] . '-space';
		$holderClasses[] = $this->getColumnNumberClass( $params );

		return implode( ' ', $holderClasses );
	}
	
	private function getColumnNumberClass( $params ) {
		$columnsNumber = '';
		$columns       = $params['number_of_columns'];
		
		switch ( $columns ) {
			case 1:
				$columnsNumber = 'qodef-one-column';
				break;
			case 2:
				$columnsNumber = 'qodef-two-columns';
				break;
			case 3:
				$columnsNumber = 'qodef-three-columns';
				break;
			case 4:
				$columnsNumber = 'qodef-four-columns';
				break;
			case 5:
				$columnsNumber = 'qodef-five-columns';
				break;
			case 6:
				$columnsNumber = 'qodef-six-columns';
				break;
			default:
				$columnsNumber = 'qodef-four-columns';
				break;
		}
		
		return $columnsNumber;
	}
	
	private function generateProductCategoryQueryArray( $params ) {
		$queryArray = get_terms( array(
			'taxonomy'   => 'product_cat',
			'number'     => $params['number_of_posts'],
			'orderby'    => $params['orderby'],
			'order'      => $params['order'],
			'slug'       => $params['category_slugs'],
			'hide_empty' => false
		) );
		
		return $queryArray;
	}
}