<article <?php post_class($classes); ?>>
    <div class="qodef-product-banner-content">
        <?php if ( has_post_thumbnail($product_id) ) { ?>
            <div class="qodef-product-banner-image">
	            <?php
	            if ( $featured_image_size != 'custom' ) {
					echo get_the_post_thumbnail($product_id, $featured_image_size);
				} elseif ( $featured_custom_image_width != '' && $featured_custom_image_height != '' ) {
					echo tonda_select_generate_thumbnail( get_post_thumbnail_id( $product_id ), null, $featured_custom_image_width, $featured_custom_image_height );
				}
	            ?>
            </div>
	        <div class="qodef-product-banner-text">
	            <div class="qodef-product-banner-text-inner">
			        <?php if (!empty($categories)) { ?>
				        <div class="qodef-product-banner-categories">
			            <?php $first_category = true;
				        foreach ( $categories as $cat ) {
					        if ( $first_category ) {
						        $first_category = false;
					        } else {
						        echo esc_html( '-' );
					        } ?>
					        <a itemprop="url" class="qodef-product-banner-category-item" href="<?php echo esc_url( get_term_link( $cat->term_id ) ); ?>"><?php echo esc_html( $cat->name ); ?></a>
					    <?php } ?>
				        </div>
			        <?php } ?>
			        <?php if (!empty($title)) { ?>
				        <<?php echo esc_attr( $title_tag ); ?> class="qodef-product-banner-title">
		                    <?php echo wp_kses( $title, array( 'br' => true ) ); ?>
	                    </<?php echo esc_attr( $title_tag ); ?>>
	                <?php } ?>
	                <?php if (!empty($price)) { ?>
			            <div class="qodef-product-banner-price"><?php echo wp_kses( $price, array( 'del' => true, 'ins' => true, 'span' => array( 'class' => true ) ) ); ?></div>
	                <?php } ?>
	            </div>
	        </div>
            <a itemprop="url" class="qodef-product-banner-link" href="<?php echo esc_url( get_the_permalink( $product_id ) ); ?>"></a>
        <?php } ?>
    </div>
</article>
