(function($) {
    'use strict';

    var woocommerce = {};
    qodef.modules.woocommerce = woocommerce;

    woocommerce.qodefOnDocumentReady = qodefOnDocumentReady;
    woocommerce.qodefOnWindowLoad = qodefOnWindowLoad;
    woocommerce.qodefOnWindowResize = qodefOnWindowResize;

    $(document).ready(qodefOnDocumentReady);
    $(window).on('load', qodefOnWindowLoad);
    $(window).resize(qodefOnWindowResize);
    
    /* 
        All functions to be called on $(document).ready() should be in this function
    */
    function qodefOnDocumentReady() {
        qodefInitQuantityButtons();
        qodefInitSelect2();
	    qodefInitSingleProductLightbox();
	    qodefAddingToWishlist();
		qodefQuickViewButton();
		qodefWishlistRefresh().init();
    }

    /* 
        All functions to be called on $(window).on('load', ) should be in this function
    */
    function qodefOnWindowLoad() {
	    qodefInitSelect2OnLoad();
        qodefInitProductListMasonryShortcode();
    }

    /* 
        All functions to be called on $(window).resize() should be in this function
    */
    function qodefOnWindowResize() {
        qodefInitProductListMasonryShortcode();
    }
	
    /*
    ** Init quantity buttons to increase/decrease products for cart
    */
	function qodefInitQuantityButtons() {
		$(document).on('click', '.qodef-quantity-minus, .qodef-quantity-plus', function (e) {
			e.stopPropagation();
			
			var button = $(this),
				inputField = button.siblings('.qodef-quantity-input'),
				step = parseFloat(inputField.data('step')),
				max = parseFloat(inputField.data('max')),
				minus = false,
				inputValue = parseFloat(inputField.val()),
				newInputValue;
			
			if (button.hasClass('qodef-quantity-minus')) {
				minus = true;
			}
			
			if (minus) {
				newInputValue = inputValue - step;
				if (newInputValue >= 1) {
					inputField.val(newInputValue);
				} else {
					inputField.val(0);
				}
			} else {
				newInputValue = inputValue + step;
				if (max === undefined) {
					inputField.val(newInputValue);
				} else {
					if (newInputValue >= max) {
						inputField.val(max);
					} else {
						inputField.val(newInputValue);
					}
				}
			}
			
			inputField.trigger('change');
		});
	}

    /*
    ** Init select2 script for select html dropdowns
    */
	function qodefInitSelect2() {
		var orderByDropDown = $('.woocommerce-ordering .orderby');
		if (orderByDropDown.length) {
			orderByDropDown.select2({
				minimumResultsForSearch: Infinity
			});
		}
		
		var shippingCountryCalc = $('#calc_shipping_country');
		if (shippingCountryCalc.length) {
			shippingCountryCalc.select2();
		}
		
		var shippingStateCalc = $('.cart-collaterals .shipping select#calc_shipping_state');
		if (shippingStateCalc.length) {
			shippingStateCalc.select2();
		}
	}
	
	function qodefInitSelect2OnLoad() {
		var variableProducts = $('.qodef-woocommerce-page .qodef-content .variations td.value select:not(.yith_wccl_custom)');
		if (variableProducts.length) {
			variableProducts.select2();
		}
	}
	
	/*
	 ** Init Product Single Pretty Photo attributes
	 */
	function qodefInitSingleProductLightbox() {
		var item = $('.qodef-woo-single-page.qodef-woo-single-has-pretty-photo .images .woocommerce-product-gallery__image');
		
		if(item.length) {
			item.children('a').attr('data-rel', 'prettyPhoto[woo_single_pretty_photo]');
			
			if (typeof qodef.modules.common.qodefPrettyPhoto === "function") {
				qodef.modules.common.qodefPrettyPhoto();
			}
		}
	}
	
	/*
	 ** Init Product List Masonry Shortcode Layout
	 */
	function qodefInitProductListMasonryShortcode() {
		var container = $('.qodef-pl-holder.qodef-masonry-layout .qodef-pl-outer');
		
		if (container.length) {
			container.each(function () {
				var thisContainer = $(this),
					size = thisContainer.find('.qodef-pl-sizer').width();
				
				thisContainer.waitForImages(function () {
					thisContainer.isotope({
						itemSelector: '.qodef-pli',
						resizable: false,
						masonry: {
							columnWidth: '.qodef-pl-sizer',
							gutter: '.qodef-pl-gutter'
						}
					});
					
					if (thisContainer.find('.qodef-woo-fixed-masonry').length) {
						qodef.modules.common.setFixedImageProportionSize(thisContainer, thisContainer.find('.qodef-pli'), size, true);
					}
					
					thisContainer.isotope('layout').css('opacity', 1);
				});
			});
		}
	}
	
	function qodefQuickViewButton() {
		var item = $('.yith-wcqv-button');
		
		if (item.length) {
			item.on('click', function () {
				var holder = $('#yith-quick-view-modal'),
					isActive = false;
				
				qodef.body.removeClass('qodef-qw-is-opened');
				
				setInterval(function () {
					if(holder.length && holder.hasClass('open') && ! isActive) {
						isActive = true;
						
						qodef.body.addClass('qodef-qw-is-opened');
					}
				}, 100);
			});
		}
	}
	
	function qodefAddingToWishlist() {
		var wishlistButtons = $('.add_to_wishlist');
		
		if (wishlistButtons.length) {
			wishlistButtons.on('click', function(){
				var wishlistButton = $(this),
					wishlistItem,
					wishlistItemOffset,
					heightAdj,
					widthAdj;
				
				var wishlistMsg = $('#yith-wcwl-popup-message');
				
				//absolute centering over added item
				if (wishlistButton.closest('.qodef-pli').length) {
					wishlistItem = wishlistButton.closest('.qodef-pli');            // product list shortcode
				} else if (wishlistButton.closest('.qodef-plc-item').length) {
					wishlistItem = wishlistButton.closest('.qodef-plc-item');       // product carousel shortcode
				} else if (wishlistButton.closest('.product').length) {
					wishlistItem = wishlistButton.closest('.product');              // WooCommerce template
				}
				
				wishlistItemOffset = wishlistItem.find('img').offset();
				heightAdj = wishlistItem.find('img').height()/2;
				widthAdj = wishlistItem.find('img').width()/2;
				
				$(document).on('added_to_wishlist', function(){
					wishlistMsg.css({
						'top': wishlistItemOffset.top + heightAdj,
						'left': wishlistItemOffset.left + widthAdj,
					});
					
					setTimeout(function(){
						wishlistMsg.stop().addClass('qodef-wishlist-vanish-out');
						wishlistMsg.one('webkitAnimationEnd oanimationend msAnimationEnd animationend' ,function(){
							wishlistMsg.removeClass('qodef-wishlist-vanish-out');
						});
					}, 300);
				});
			});
		}
	}

	function qodefWishlistRefresh() {

        var initRefreshWishlist = function($type){
	        var count = $('.qodef-wishlist-widget-holder').find('.qodef-wishlist-widget-count'),
	            countValue = count.length ? parseInt(count.text(), 10) : 0,
	            newValue;

	        if ($type == 'plus') {
		        newValue = countValue + 1;
	        } else {
		        newValue = countValue > 0 ? countValue - 1 : 0;
	        }
	
	        count.text(newValue);
        };

        return {
            init: function () {
                //trigger defined in jquery.yith-wcwl.js, after product is added to wishlist
                $('body').on('added_to_wishlist',function(){
	                initRefreshWishlist('plus');
                });

                //after product is removed from wishlist list
                $('#yith-wcwl-form').on('click', '.product-remove a, .product-add-to-cart a', function() {
                    setTimeout(function() {
                        initRefreshWishlist('minus');
                    }, 2000);
                });
            }

        }

    }

})(jQuery);