<?php

if ( ! function_exists( 'tonda_select_woocommerce_category_fields' ) ) {
	function tonda_select_woocommerce_category_fields() {
		
		$fields = tonda_select_add_taxonomy_fields(
			array(
				'scope' => 'product_cat',
				'name'  => 'woocommerce_category_options'
			)
		);
		
		tonda_select_add_taxonomy_field(
			array(
				'name'          => 'woo_category_masonry_fixed_dimensions',
				'type'          => 'selectblank',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Fixed Proportion', 'tonda' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type WooCommerce product category lists where image proportion is fixed', 'tonda' ),
				'options'       => array(
					''                   => esc_html__( 'Default', 'tonda' ),
					'small'              => esc_html__( 'Small', 'tonda' ),
					'large-width'        => esc_html__( 'Large Width', 'tonda' ),
					'large-height'       => esc_html__( 'Large Height', 'tonda' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'tonda' )
				),
				'parent'        => $fields
			)
		);
	}
	
	add_action( 'tonda_select_action_custom_taxonomy_fields', 'tonda_select_woocommerce_category_fields' );
}