<?php

if ( ! function_exists( 'tonda_select_map_woocommerce_meta' ) ) {
	function tonda_select_map_woocommerce_meta() {
		
		$woocommerce_meta_box = tonda_select_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'tonda' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'tonda' ),
				'description' => esc_html__( 'Choose image layout when it appears in Select Product List - Masonry layout shortcode', 'tonda' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'tonda' ),
					'small'              => esc_html__( 'Small', 'tonda' ),
					'large-width'        => esc_html__( 'Large Width', 'tonda' ),
					'large-height'       => esc_html__( 'Large Height', 'tonda' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'tonda' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'tonda' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'tonda' ),
				'options'       => tonda_select_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'tonda' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'tonda' ),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_woo_single_additional_info_size_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Set Product Additional Info Full Width', 'tonda' ),
				'options'       => tonda_select_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'tonda_select_action_meta_boxes_map', 'tonda_select_map_woocommerce_meta', 99 );
}