<?php

if ( ! function_exists( 'tonda_select_sidebar_options_map' ) ) {
	function tonda_select_sidebar_options_map() {
		
		tonda_select_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'tonda' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = tonda_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'tonda' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		tonda_select_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'tonda' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'tonda' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => tonda_select_get_custom_sidebars_options()
		) );
		
		$tonda_custom_sidebars = tonda_select_get_custom_sidebars();
		if ( count( $tonda_custom_sidebars ) > 0 ) {
			tonda_select_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'tonda' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'tonda' ),
				'parent'      => $sidebar_panel,
				'options'     => $tonda_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'tonda_select_action_options_map', 'tonda_select_sidebar_options_map', 9 );
}