<?php

if ( ! function_exists( 'tonda_select_map_sidebar_meta' ) ) {
	function tonda_select_map_sidebar_meta() {
		$qodef_sidebar_meta_box = tonda_select_create_meta_box(
			array(
				'scope' => apply_filters( 'tonda_select_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'tonda' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'tonda' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'tonda' ),
				'parent'      => $qodef_sidebar_meta_box,
                'options'       => tonda_select_get_custom_sidebars_options( true )
			)
		);
		
		$qodef_custom_sidebars = tonda_select_get_custom_sidebars();
		if ( count( $qodef_custom_sidebars ) > 0 ) {
			tonda_select_create_meta_box_field(
				array(
					'name'        => 'qodef_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'tonda' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'tonda' ),
					'parent'      => $qodef_sidebar_meta_box,
					'options'     => $qodef_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'tonda_select_action_meta_boxes_map', 'tonda_select_map_sidebar_meta', 31 );
}