<?php

if (!function_exists('tonda_select_sidearea_options_map')) {
    function tonda_select_sidearea_options_map() {

        tonda_select_add_admin_page(
            array(
                'slug'  => '_side_area_page',
                'title' => esc_html__('Side Area', 'tonda'),
                'icon'  => 'fa fa-indent'
            )
        );

        $side_area_panel = tonda_select_add_admin_panel(
            array(
                'title' => esc_html__('Side Area', 'tonda'),
                'name'  => 'side_area',
                'page'  => '_side_area_page'
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_type',
                'default_value' => 'side-menu-slide-from-right',
                'label'         => esc_html__('Side Area Type', 'tonda'),
                'description'   => esc_html__('Choose a type of Side Area', 'tonda'),
                'options'       => array(
                    'side-menu-slide-from-right'       => esc_html__('Slide from Right Over Content', 'tonda'),
                    'side-menu-slide-with-content'     => esc_html__('Slide from Right With Content', 'tonda'),
                    'side-area-uncovered-from-content' => esc_html__('Side Area Uncovered from Content', 'tonda'),
                ),
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'text',
                'name'          => 'side_area_width',
                'default_value' => '',
                'label'         => esc_html__('Side Area Width', 'tonda'),
                'description'   => esc_html__('Enter a width for Side Area (px or %). Default width: 405px.', 'tonda'),
                'args'          => array(
                    'col_width' => 3,
                )
            )
        );

        $side_area_width_container = tonda_select_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_width_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_type' => 'side-menu-slide-from-right',
                    )
                )
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'color',
                'name'          => 'side_area_content_overlay_color',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Color', 'tonda'),
                'description'   => esc_html__('Choose a background color for a content overlay', 'tonda'),
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'text',
                'name'          => 'side_area_content_overlay_opacity',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Transparency', 'tonda'),
                'description'   => esc_html__('Choose a transparency for the content overlay background color (0 = fully transparent, 1 = opaque)', 'tonda'),
                'args'          => array(
                    'col_width' => 3
                )
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_icon_source',
                'default_value' => 'predefined',
                'label'         => esc_html__('Select Side Area Icon Source', 'tonda'),
                'description'   => esc_html__('Choose whether you would like to use icons from an icon pack or SVG icons', 'tonda'),
                'options'       => tonda_select_get_icon_sources_array( false, true )
            )
        );

        $side_area_icon_pack_container = tonda_select_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_icon_pack_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'icon_pack'
                    )
                )
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'        => $side_area_icon_pack_container,
                'type'          => 'select',
                'name'          => 'side_area_icon_pack',
                'default_value' => 'font_elegant',
                'label'         => esc_html__('Side Area Icon Pack', 'tonda'),
                'description'   => esc_html__('Choose icon pack for Side Area icon', 'tonda'),
                'options'       => tonda_select_icon_collections()->getIconCollectionsExclude(array('linea_icons', 'dripicons', 'simple_line_icons'))
            )
        );

        $side_area_svg_icons_container = tonda_select_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_svg_icons_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'svg_path'
                    )
                )
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_icon_svg_path',
                'label'       => esc_html__('Side Area Icon SVG Path', 'tonda'),
                'description' => esc_html__('Enter your Side Area icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'tonda'),
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_close_icon_svg_path',
                'label'       => esc_html__('Side Area Close Icon SVG Path', 'tonda'),
                'description' => esc_html__('Enter your Side Area close icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'tonda'),
            )
        );

        $side_area_icon_style_group = tonda_select_add_admin_group(
            array(
                'parent'      => $side_area_panel,
                'name'        => 'side_area_icon_style_group',
                'title'       => esc_html__('Side Area Icon Style', 'tonda'),
                'description' => esc_html__('Define styles for Side Area icon', 'tonda')
            )
        );

        $side_area_icon_style_row1 = tonda_select_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row1'
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_color',
                'label'  => esc_html__('Color', 'tonda')
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_hover_color',
                'label'  => esc_html__('Hover Color', 'tonda')
            )
        );

        $side_area_icon_style_row2 = tonda_select_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row2',
                'next'   => true
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_color',
                'label'  => esc_html__('Close Icon Color', 'tonda')
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_hover_color',
                'label'  => esc_html__('Close Icon Hover Color', 'tonda')
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'color',
                'name'        => 'side_area_background_color',
                'label'       => esc_html__('Background Color', 'tonda'),
                'description' => esc_html__('Choose a background color for Side Area', 'tonda')
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'text',
                'name'        => 'side_area_padding',
                'label'       => esc_html__('Padding', 'tonda'),
                'description' => esc_html__('Define padding for Side Area in format top right bottom left', 'tonda'),
                'args'        => array(
                    'col_width' => 3
                )
            )
        );

        tonda_select_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'selectblank',
                'name'          => 'side_area_aligment',
                'default_value' => '',
                'label'         => esc_html__('Text Alignment', 'tonda'),
                'description'   => esc_html__('Choose text alignment for side area', 'tonda'),
                'options'       => array(
                    ''       => esc_html__('Default', 'tonda'),
                    'left'   => esc_html__('Left', 'tonda'),
                    'center' => esc_html__('Center', 'tonda'),
                    'right'  => esc_html__('Right', 'tonda')
                )
            )
        );
    }

    add_action('tonda_select_action_options_map', 'tonda_select_sidearea_options_map', 15);
}