<?php

if ( ! function_exists( 'tonda_select_get_popup' ) ) {
	/**
	 * Loads search HTML based on search type option.
	 */
	function tonda_select_get_popup() {
		
		if ( tonda_select_active_widget( false, false, 'qodef_popup_opener' ) && tonda_select_options()->getOptionValue( 'enable_popup' ) == 'yes' ) {
			tonda_select_load_popup_template();
		}
	}
}

if ( ! function_exists( 'tonda_select_load_popup_template' ) ) {
	/**
	 * Loads HTML template with parameters
	 */
	function tonda_select_load_popup_template() {
		$parameters                           = array();
		
		$popup_background_image = tonda_select_options()->getOptionValue( 'popup_background_image' );
		
		$parameters['holder_classes']         = ! empty( $popup_background_image ) ? 'qodef-popup-has-image' : '';
		$parameters['title']                  = tonda_select_options()->getOptionValue( 'popup_title' );
		$parameters['subtitle']               = tonda_select_options()->getOptionValue( 'popup_subtitle' );
		$parameters['popup_background_image'] = $popup_background_image;
		$parameters['contact_form']           = tonda_select_options()->getOptionValue( 'popup_contact_form' );
		$parameters['contact_form_style']     = tonda_select_options()->getOptionValue( 'popup_contact_form_style' );
		
		tonda_select_get_module_template_part( 'templates/popup', 'popup', '', $parameters );
	}
}