<?php

if ( ! function_exists( 'tonda_select_popup_options_map' ) ) {
	function tonda_select_popup_options_map() {
		$cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );
		
		$contact_forms = array();
		if ( $cf7 ) {
			foreach ( $cf7 as $cform ) {
				$contact_forms[ $cform->ID ] = $cform->post_title;
			}
		} else {
			$contact_forms[0] = esc_html__( 'No contact forms found', 'tonda' );
		}
		
		tonda_select_add_admin_page(
			array(
				'slug'  => '_popup_page',
				'title' => esc_html__( 'Subscribe Pop-up', 'tonda' ),
				'icon'  => 'fa fa-pencil-square-o'
			)
		);
		
		$popup_panel = tonda_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Subscribe Pop-up', 'tonda' ),
				'name'  => 'popup',
				'page'  => '_popup_page'
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $popup_panel,
				'type'          => 'yesno',
				'name'          => 'enable_popup',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Subscribe Pop-up', 'tonda' )
			)
		);
		
		$enable_popup_container = tonda_select_add_admin_container(
			array(
				'parent'     => $popup_panel,
				'name'       => 'enable_popup_container',
				'dependency' => array(
					'hide' => array(
						'enable_popup' => array( 'no', '' )
					)
				)
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'      => $enable_popup_container,
				'type'        => 'text',
				'name'        => 'popup_title',
				'label'       => esc_html__( 'Title', 'tonda' ),
				'description' => esc_html__( 'Enter title subscribe popup window', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'      => $enable_popup_container,
				'type'        => 'text',
				'name'        => 'popup_subtitle',
				'label'       => esc_html__( 'Subtitle', 'tonda' ),
				'description' => esc_html__( 'Enter subtitle subscribe popup window', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent' => $enable_popup_container,
				'type'   => 'image',
				'name'   => 'popup_background_image',
				'label'  => esc_html__( 'Background Image', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'name'          => 'popup_contact_form',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Select Contact Form', 'tonda' ),
				'description'   => esc_html__( 'Choose contact form to display in subscribe popup window', 'tonda' ),
				'parent'        => $enable_popup_container,
				'options'       => $contact_forms
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'name'          => 'popup_contact_form_style',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Contact Form Style', 'tonda' ),
				'description'   => esc_html__( 'Choose style defined in Contact Form 7 option tab', 'tonda' ),
				'parent'        => $enable_popup_container,
				'options'       => array(
					'default'            => esc_html__( 'Default', 'tonda' ),
					'cf7_custom_style_1' => esc_html__( 'Custom Style 1', 'tonda' ),
					'cf7_custom_style_2' => esc_html__( 'Custom Style 2', 'tonda' ),
					'cf7_custom_style_3' => esc_html__( 'Custom Style 3', 'tonda' )
				)
			)
		);
	}
	
	add_action( 'tonda_select_action_options_map', 'tonda_select_popup_options_map', 16 );
}