(function ($) {
	"use strict";
	
	var subscribe = {};
	qodef.modules.subscribe = subscribe;
	
	subscribe.qodefOnDocumentReady = qodefOnDocumentReady;
	
	$(document).ready(qodefOnDocumentReady);
	
	function qodefOnDocumentReady() {
		qodefInitSubscribePopup();
	}
	
	function qodefInitSubscribePopup() {
		var popupOpener = $('a.qodef-popup-opener'),
			popupClose = $('.qodef-popup-close');
		
		popupOpener.on('click', function (e) {
			e.preventDefault();
			
			if (qodef.body.hasClass('qodef-popup-opened')) {
				qodef.body.removeClass('qodef-popup-opened');
				qodef.modules.common.qodefEnableScroll();
			} else {
				qodef.body.addClass('qodef-popup-opened');
				qodef.modules.common.qodefDisableScroll();
			}
			
			popupClose.on('click', function (e) {
				e.preventDefault();
				
				qodef.body.removeClass('qodef-popup-opened');
				qodef.modules.common.qodefEnableScroll();
			});
			
			//Close on escape
			$(document).keyup(function (e) {
				if (e.keyCode === 27) { //KeyCode for ESC button is 27
					qodef.body.removeClass('qodef-popup-opened');
					qodef.modules.common.qodefEnableScroll();
				}
			});
		});
	}
	
})(jQuery);