<?php

if ( ! function_exists( 'tonda_select_get_hide_dep_for_header_standard_options' ) ) {
	function tonda_select_get_hide_dep_for_header_standard_options() {
		$hide_dep_options = apply_filters( 'tonda_select_filter_header_standard_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'tonda_select_header_standard_map' ) ) {
	function tonda_select_header_standard_map( $parent ) {
		$hide_dep_options = tonda_select_get_hide_dep_for_header_standard_options();
		
		tonda_select_add_admin_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'set_menu_area_position',
				'default_value'   => 'left',
				'label'           => esc_html__( 'Choose Menu Area Position', 'tonda' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'tonda' ),
				'options'         => array(
					'right'  => esc_html__( 'Right', 'tonda' ),
					'left'   => esc_html__( 'Left', 'tonda' ),
					'center' => esc_html__( 'Center', 'tonda' )
				),
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'tonda_select_action_additional_header_menu_area_options_map', 'tonda_select_header_standard_map' );
}