<?php

if ( ! function_exists( 'tonda_select_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function tonda_select_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'tonda_select_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'tonda_select_header_standard_meta_map' ) ) {
	function tonda_select_header_standard_meta_map( $parent ) {
		$hide_dep_options = tonda_select_get_hide_dep_for_header_standard_meta_boxes();
		
		tonda_select_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'qodef_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'tonda' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'tonda' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'tonda' ),
					'left'   => esc_html__( 'Left', 'tonda' ),
					'right'  => esc_html__( 'Right', 'tonda' ),
					'center' => esc_html__( 'Center', 'tonda' )
				),
				'dependency' => array(
					'hide' => array(
						'qodef_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'tonda_select_action_additional_header_area_meta_boxes_map', 'tonda_select_header_standard_meta_map' );
}