<?php

if ( ! function_exists( 'tonda_select_register_header_minimal_type' ) ) {
	/**
	 * This function is used to register header type class for header factory file
	 */
	function tonda_select_register_header_minimal_type( $header_types ) {
		$header_type = array(
			'header-minimal' => 'TondaSelectNamespace\Modules\Header\Types\HeaderMinimal'
		);
		
		$header_types = array_merge( $header_types, $header_type );
		
		return $header_types;
	}
}

if ( ! function_exists( 'tonda_select_init_register_header_minimal_type' ) ) {
	/**
	 * This function is used to wait header-function.php file to init header object and then to init hook registration function above
	 */
	function tonda_select_init_register_header_minimal_type() {
		add_filter( 'tonda_select_filter_register_header_type_class', 'tonda_select_register_header_minimal_type' );
	}
	
	add_action( 'tonda_select_action_before_header_function_init', 'tonda_select_init_register_header_minimal_type' );
}

if ( ! function_exists( 'tonda_select_include_header_minimal_full_screen_menu' ) ) {
	/**
	 * Registers additional menu navigation for theme
	 */
	function tonda_select_include_header_minimal_full_screen_menu( $menus ) {
		$menus['popup-navigation'] = esc_html__( 'Full Screen Navigation', 'tonda' );
		
		return $menus;
	}
	
	if ( tonda_select_check_is_header_type_enabled( 'header-minimal' ) ) {
		add_filter( 'tonda_select_filter_register_headers_menu', 'tonda_select_include_header_minimal_full_screen_menu' );
	}
}

if ( ! function_exists( 'tonda_select_get_fullscreen_menu_icon_class' ) ) {
	/**
	 * Loads full screen menu icon class
	 */
	function tonda_select_get_fullscreen_menu_icon_class() {

		$fullscreen_menu_icon_source = tonda_select_options()->getOptionValue( 'fullscreen_menu_icon_source' );

		$fullscreen_menu_icon_class_array = array(
			'qodef-fullscreen-menu-opener'
		);
		
		if ( $fullscreen_menu_icon_source == 'icon_pack' ) {
			$fullscreen_menu_icon_class_array[] = 'qodef-fullscreen-menu-opener-icon-pack';
		} else if ( $fullscreen_menu_icon_source == 'predefined' ) {
			$fullscreen_menu_icon_class_array[] = 'qodef-fullscreen-menu-opener-predefined';
		} else {
			$fullscreen_menu_icon_class_array[] = 'qodef-fullscreen-menu-opener-svg-path';
		}
		
		return $fullscreen_menu_icon_class_array;
	}
}

if ( ! function_exists( 'tonda_select_get_fullscreen_menu_icon_html' ) ) {
	/**
	 * Loads fullscreen menu icon HTML
	 */
	function tonda_select_get_fullscreen_menu_icon_html() {

		$fullscreen_menu_icon_source	= tonda_select_options()->getOptionValue( 'fullscreen_menu_icon_source' );
		$fullscreen_menu_icon_pack		= tonda_select_options()->getOptionValue( 'fullscreen_menu_icon_pack' );
		$fullscreen_menu_icon_svg_path 	= tonda_select_options()->getOptionValue( 'fullscreen_menu_icon_svg_path' );

		$fullscreen_menu_icon_html = '';
		
		if ( ( $fullscreen_menu_icon_source == 'icon_pack' ) && ( isset( $mobile_icon_icon_pack ) ) ) {
			$fullscreen_menu_icon_html .= tonda_select_icon_collections()->getMenuIcon($fullscreen_menu_icon_pack);
		} else if ( $fullscreen_menu_icon_source == 'predefined' ) {
			$fullscreen_menu_icon_html .= '<span class="qodef-fsm-icons">';
			$fullscreen_menu_icon_html .= '<span class="qodef-fsm-line qodef-fsm-line-1"></span>';
			$fullscreen_menu_icon_html .= '<span class="qodef-fsm-line qodef-fsm-line-2"></span>';
			$fullscreen_menu_icon_html .= '<span class="qodef-fsm-line qodef-fsm-line-3"></span>';
			$fullscreen_menu_icon_html .= '</span>';
		} else if ( isset( $mobile_icon_svg_path ) ) {
			$fullscreen_menu_icon_html .= $fullscreen_menu_icon_svg_path;
		}

		return $fullscreen_menu_icon_html;
	}
}

if ( ! function_exists( 'tonda_select_get_fullscreen_menu_close_icon_html' ) ) {
	/**
	 * Loads fullscreen menu close icon HTML
	 */
	function tonda_select_get_fullscreen_menu_close_icon_html() {

		$fullscreen_menu_icon_source			= tonda_select_options()->getOptionValue( 'fullscreen_menu_icon_source' );
		$fullscreen_menu_icon_pack				= tonda_select_options()->getOptionValue( 'fullscreen_menu_icon_pack' );
		$fullscreen_menu_close_icon_svg_path 	= tonda_select_options()->getOptionValue( 'fullscreen_menu_close_icon_svg_path' );

		$fullscreen_menu_close_icon_html = '';
		
		if (($fullscreen_menu_icon_source == 'icon_pack') && isset($fullscreen_menu_icon_pack)) {
			$fullscreen_menu_close_icon_html .= tonda_select_icon_collections()->getMenuCloseIcon($fullscreen_menu_icon_pack);
		} else if ( $fullscreen_menu_icon_source == 'predefined' ) {
			$fullscreen_menu_close_icon_html .= tonda_select_icon_collections()->getMenuCloseIcon( 'linear_icons' );
		} else if (isset($side_area_close_icon_svg_path)) {
			$fullscreen_menu_close_icon_html .= $fullscreen_menu_close_icon_svg_path;
		}

		return $fullscreen_menu_close_icon_html;
	}
}

if ( ! function_exists( 'tonda_select_register_header_minimal_full_screen_menu_widgets' ) ) {
	/**
	 * Registers additional widget areas for this header type
	 */
	function tonda_select_register_header_minimal_full_screen_menu_widgets() {
		
		register_sidebar(
			array(
				'id'            => 'fullscreen_menu_below',
				'name'          => esc_html__( 'Fullscreen Menu Bottom', 'tonda' ),
				'description'   => esc_html__( 'This widget area is rendered below full screen menu', 'tonda' ),
				'before_widget' => '<div class="%2$s qodef-fullscreen-menu-below-widget">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="qodef-widget-title">',
				'after_title'   => '</h5>'
			)
		);
	}
	
	if ( tonda_select_check_is_header_type_enabled( 'header-minimal' ) ) {
		add_action( 'widgets_init', 'tonda_select_register_header_minimal_full_screen_menu_widgets' );
	}
}