<?php

if ( ! function_exists( 'tonda_select_register_header_centered_type' ) ) {
	/**
	 * This function is used to register header type class for header factory file
	 */
	function tonda_select_register_header_centered_type( $header_types ) {
		$header_type = array(
			'header-centered' => 'TondaSelectNamespace\Modules\Header\Types\HeaderCentered'
		);
		
		$header_types = array_merge( $header_types, $header_type );
		
		return $header_types;
	}
}

if ( ! function_exists( 'tonda_select_init_register_header_centered_type' ) ) {
	/**
	 * This function is used to wait header-function.php file to init header object and then to init hook registration function above
	 */
	function tonda_select_init_register_header_centered_type() {
		add_filter( 'tonda_select_filter_register_header_type_class', 'tonda_select_register_header_centered_type' );
	}
	
	add_action( 'tonda_select_action_before_header_function_init', 'tonda_select_init_register_header_centered_type' );
}

if ( ! function_exists( 'tonda_select_header_centered_per_page_custom_styles' ) ) {
	/**
	 * Return header per page styles
	 */
	function tonda_select_header_centered_per_page_custom_styles( $style, $class_prefix, $page_id ) {
		$header_area_style    = array();
		$header_area_selector = array( $class_prefix . '.qodef-header-centered .qodef-logo-area .qodef-logo-wrapper' );
		
		$logo_area_logo_padding = get_post_meta( $page_id, 'qodef_logo_wrapper_padding_header_centered_meta', true );
		
		if ( $logo_area_logo_padding !== '' ) {
			$header_area_style['padding'] = $logo_area_logo_padding;
		}
		
		$current_style = '';
		
		if ( ! empty( $header_area_style ) ) {
			$current_style .= tonda_select_dynamic_css( $header_area_selector, $header_area_style );
		}
		
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'tonda_select_filter_add_header_page_custom_style', 'tonda_select_header_centered_per_page_custom_styles', 10, 3 );
}

if ( ! function_exists( 'tonda_select_header_centered_widget_areas' ) ) {
	/**
	 * Registers widget areas for header types
	 */
	function tonda_select_header_centered_widget_areas() {
		register_sidebar(
			array(
				'id'            => 'qodef-header-centered-widget-left',
				'name'          => esc_html__( 'Header Centered Left Widget Area', 'tonda' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s qodef-header-left-widget-area">',
				'after_widget'  => '</div>',
				'description'   => esc_html__( 'Widgets added here will appear left from main menu', 'tonda' )
			)
		);

		register_sidebar(
			array(
				'id'            => 'qodef-header-centered-widget-right',
				'name'          => esc_html__( 'Header Centered Right Widget Area', 'tonda' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s qodef-header-right-widget-area">',
				'after_widget'  => '</div>',
				'description'   => esc_html__( 'Widgets added here will appear right from main menu', 'tonda' )
			)
		);
	}

	if ( tonda_select_check_is_header_type_enabled( 'header-centered' ) ) {
		add_action( 'widgets_init', 'tonda_select_header_centered_widget_areas' );
	}
}