<?php

if ( ! function_exists( 'tonda_select_get_hide_dep_for_header_centered_options' ) ) {
	function tonda_select_get_hide_dep_for_header_centered_options() {
		$hide_dep_options = apply_filters( 'tonda_select_filter_header_centered_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'tonda_select_header_centered_map' ) ) {
	function tonda_select_header_centered_map( $parent ) {
		$hide_dep_options = tonda_select_get_hide_dep_for_header_centered_options();
		
		tonda_select_add_admin_field(
			array(
				'parent'          => $parent,
				'type'            => 'text',
				'name'            => 'logo_wrapper_padding_header_centered',
				'default_value'   => '',
				'label'           => esc_html__( 'Logo Padding', 'tonda' ),
				'description'     => esc_html__( 'Insert padding in format: 0px 0px 1px 0px', 'tonda' ),
				'args'            => array(
					'col_width' => 3
				),
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'tonda_select_header_logo_area_additional_options', 'tonda_select_header_centered_map' );
}