<?php

if ( ! function_exists( 'tonda_select_logo_options_map' ) ) {
	function tonda_select_logo_options_map() {
		
		tonda_select_add_admin_page(
			array(
				'slug'  => '_logo_page',
				'title' => esc_html__( 'Logo', 'tonda' ),
				'icon'  => 'fa fa-coffee'
			)
		);
		
		$panel_logo = tonda_select_add_admin_panel(
			array(
				'page'  => '_logo_page',
				'name'  => 'panel_logo',
				'title' => esc_html__( 'Logo', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $panel_logo,
				'type'          => 'yesno',
				'name'          => 'hide_logo',
				'default_value' => 'no',
				'label'         => esc_html__( 'Hide Logo', 'tonda' ),
				'description'   => esc_html__( 'Enabling this option will hide logo image', 'tonda' )
			)
		);
		
		$hide_logo_container = tonda_select_add_admin_container(
			array(
				'parent'          => $panel_logo,
				'name'            => 'hide_logo_container',
				'dependency' => array(
					'hide' => array(
						'hide_logo'  => 'yes'
					)
				)
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'name'          => 'logo_image',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Default', 'tonda' ),
				'parent'        => $hide_logo_container
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'name'          => 'logo_image_dark',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Dark', 'tonda' ),
				'parent'        => $hide_logo_container
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'name'          => 'logo_image_light',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo_white.png",
				'label'         => esc_html__( 'Logo Image - Light', 'tonda' ),
				'parent'        => $hide_logo_container
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'name'          => 'logo_image_sticky',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Sticky', 'tonda' ),
				'parent'        => $hide_logo_container
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'name'          => 'logo_image_mobile',
				'type'          => 'image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Mobile', 'tonda' ),
				'parent'        => $hide_logo_container
			)
		);
	}
	
	add_action( 'tonda_select_action_options_map', 'tonda_select_logo_options_map', 2 );
}