<?php

if ( ! function_exists( 'tonda_select_header_types_meta_boxes' ) ) {
	function tonda_select_header_types_meta_boxes() {
		$header_type_options = apply_filters( 'tonda_select_filter_header_type_meta_boxes', $header_type_options = array( '' => esc_html__( 'Default', 'tonda' ) ) );
		
		return $header_type_options;
	}
}

if ( ! function_exists( 'tonda_select_get_hide_dep_for_header_behavior_meta_boxes' ) ) {
	function tonda_select_get_hide_dep_for_header_behavior_meta_boxes() {
		$hide_dep_options = apply_filters( 'tonda_select_filter_header_behavior_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

foreach ( glob( SELECT_FRAMEWORK_HEADER_ROOT_DIR . '/admin/meta-boxes/*/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

foreach ( glob( SELECT_FRAMEWORK_HEADER_TYPES_ROOT_DIR . '/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'tonda_select_map_header_meta' ) ) {
	function tonda_select_map_header_meta() {
		$header_type_meta_boxes              = tonda_select_header_types_meta_boxes();
		$header_behavior_meta_boxes_hide_dep = tonda_select_get_hide_dep_for_header_behavior_meta_boxes();
		
		$header_meta_box = tonda_select_create_meta_box(
			array(
				'scope' => apply_filters( 'tonda_select_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'header_meta' ),
				'title' => esc_html__( 'Header', 'tonda' ),
				'name'  => 'header_meta'
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_header_type_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Choose Header Type', 'tonda' ),
				'description'   => esc_html__( 'Select header type layout', 'tonda' ),
				'parent'        => $header_meta_box,
				'options'       => $header_type_meta_boxes
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_header_style_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Header Skin', 'tonda' ),
				'description'   => esc_html__( 'Choose a header style to make header elements (logo, main menu, side menu button) in that predefined style', 'tonda' ),
				'parent'        => $header_meta_box,
				'options'       => array(
					''             => esc_html__( 'Default', 'tonda' ),
					'light-header' => esc_html__( 'Light', 'tonda' ),
					'dark-header'  => esc_html__( 'Dark', 'tonda' )
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'parent'          => $header_meta_box,
				'type'            => 'select',
				'name'            => 'qodef_header_behaviour_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Header Behaviour', 'tonda' ),
				'description'     => esc_html__( 'Select the behaviour of header when you scroll down to page', 'tonda' ),
				'options'         => array(
					''                                => esc_html__( 'Default', 'tonda' ),
					'fixed-on-scroll'                 => esc_html__( 'Fixed on scroll', 'tonda' ),
					'no-behavior'                     => esc_html__( 'No Behavior', 'tonda' ),
					'sticky-header-on-scroll-up'      => esc_html__( 'Sticky on scroll up', 'tonda' ),
					'sticky-header-on-scroll-down-up' => esc_html__( 'Sticky on scroll up/down', 'tonda' )
				),
				'dependency' => array(
					'hide' => array(
						'qodef_header_type_meta'  => $header_behavior_meta_boxes_hide_dep
					)
				)
			)
		);
		
		//additional area
		do_action( 'tonda_select_action_additional_header_area_meta_boxes_map', $header_meta_box );
		
		//top area
		do_action( 'tonda_select_action_header_top_area_meta_boxes_map', $header_meta_box );
		
		//logo area
		do_action( 'tonda_select_action_header_logo_area_meta_boxes_map', $header_meta_box );
		
		//menu area
		do_action( 'tonda_select_action_header_menu_area_meta_boxes_map', $header_meta_box );
	}
	
	add_action( 'tonda_select_action_meta_boxes_map', 'tonda_select_map_header_meta', 50 );
}