<?php

if ( ! function_exists( 'tonda_select_error_404_options_map' ) ) {
	function tonda_select_error_404_options_map() {
		
		tonda_select_add_admin_page(
			array(
				'slug'  => '__404_error_page',
				'title' => esc_html__( '404 Error Page', 'tonda' ),
				'icon'  => 'fa fa-exclamation-triangle'
			)
		);
		
		$panel_404_header = tonda_select_add_admin_panel(
			array(
				'page'  => '__404_error_page',
				'name'  => 'panel_404_header',
				'title' => esc_html__( 'Header', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'      => $panel_404_header,
				'type'        => 'color',
				'name'        => '404_menu_area_background_color_header',
				'label'       => esc_html__( 'Background Color', 'tonda' ),
				'description' => esc_html__( 'Choose a background color for header area', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $panel_404_header,
				'type'          => 'text',
				'name'          => '404_menu_area_background_transparency_header',
				'default_value' => '',
				'label'         => esc_html__( 'Background Transparency', 'tonda' ),
				'description'   => esc_html__( 'Choose a transparency for the header background color (0 = fully transparent, 1 = opaque)', 'tonda' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'      => $panel_404_header,
				'type'        => 'color',
				'name'        => '404_menu_area_border_color_header',
				'label'       => esc_html__( 'Border Color', 'tonda' ),
				'description' => esc_html__( 'Choose a border bottom color for header area', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $panel_404_header,
				'type'          => 'select',
				'name'          => '404_header_style',
				'default_value' => '',
				'label'         => esc_html__( 'Header Skin', 'tonda' ),
				'description'   => esc_html__( 'Choose a header style to make header elements (logo, main menu, side menu button) in that predefined style', 'tonda' ),
				'options'       => array(
					''             => esc_html__( 'Default', 'tonda' ),
					'light-header' => esc_html__( 'Light', 'tonda' ),
					'dark-header'  => esc_html__( 'Dark', 'tonda' )
				)
			)
		);
		
		$panel_404_options = tonda_select_add_admin_panel(
			array(
				'page'  => '__404_error_page',
				'name'  => 'panel_404_options',
				'title' => esc_html__( '404 Page Options', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent' => $panel_404_options,
				'type'   => 'color',
				'name'   => '404_page_background_color',
				'label'  => esc_html__( 'Background Color', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'image',
				'name'          => '404_page_background_image',
				'default_value' => SELECT_ASSETS_ROOT . "/img/404-bg-img.jpg",
				'label'         => esc_html__( 'Background Image', 'tonda' ),
				'description'   => esc_html__( 'Choose a background image for 404 page', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'      => $panel_404_options,
				'type'        => 'image',
				'name'        => '404_page_background_pattern_image',
				'label'       => esc_html__( 'Pattern Background Image', 'tonda' ),
				'description' => esc_html__( 'Choose a pattern image for 404 page', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'text',
				'name'          => '404_title',
				'default_value' => '',
				'label'         => esc_html__( 'Title', 'tonda' ),
				'description'   => esc_html__( 'Enter title for 404 page. Default label is "404".', 'tonda' )
			)
		);
		
		$first_level_group = tonda_select_add_admin_group(
			array(
				'parent'      => $panel_404_options,
				'name'        => 'first_level_group',
				'title'       => esc_html__( 'Title Style', 'tonda' ),
				'description' => esc_html__( 'Define styles for 404 page title', 'tonda' )
			)
		);
		
		$first_level_row1 = tonda_select_add_admin_row(
			array(
				'parent' => $first_level_group,
				'name'   => 'first_level_row1'
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent' => $first_level_row1,
				'type'   => 'colorsimple',
				'name'   => '404_title_color',
				'label'  => esc_html__( 'Text Color', 'tonda' ),
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $first_level_row1,
				'type'          => 'fontsimple',
				'name'          => '404_title_google_fonts',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'tonda' ),
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $first_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_title_font_size',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'tonda' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $first_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_title_line_height',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'tonda' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$first_level_row2 = tonda_select_add_admin_row(
			array(
				'parent' => $first_level_group,
				'name'   => 'first_level_row2',
				'next'   => true
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_title_font_style',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'tonda' ),
				'options'       => tonda_select_get_font_style_array()
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_title_font_weight',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'tonda' ),
				'options'       => tonda_select_get_font_weight_array()
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'textsimple',
				'name'          => '404_title_letter_spacing',
				'default_value' => '',
				'label'         => esc_html__( 'Letter Spacing', 'tonda' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_title_text_transform',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'tonda' ),
				'options'       => tonda_select_get_text_transform_array()
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'text',
				'name'          => '404_text',
				'default_value' => '',
				'label'         => esc_html__( 'Text', 'tonda' ),
				'description'   => esc_html__( 'Enter text for 404 page.', 'tonda' )
			)
		);
		
		$third_level_group = tonda_select_add_admin_group(
			array(
				'parent'      => $panel_404_options,
				'name'        => '$third_level_group',
				'title'       => esc_html__( 'Text Style', 'tonda' ),
				'description' => esc_html__( 'Define styles for 404 page text', 'tonda' )
			)
		);
		
		$third_level_row1 = tonda_select_add_admin_row(
			array(
				'parent' => $third_level_group,
				'name'   => '$third_level_row1'
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent' => $third_level_row1,
				'type'   => 'colorsimple',
				'name'   => '404_text_color',
				'label'  => esc_html__( 'Text Color', 'tonda' ),
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $third_level_row1,
				'type'          => 'fontsimple',
				'name'          => '404_text_google_fonts',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'tonda' ),
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $third_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_text_font_size',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'tonda' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $third_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_text_line_height',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'tonda' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$third_level_row2 = tonda_select_add_admin_row(
			array(
				'parent' => $third_level_group,
				'name'   => '$third_level_row2',
				'next'   => true
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_text_font_style',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'tonda' ),
				'options'       => tonda_select_get_font_style_array()
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_text_font_weight',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'tonda' ),
				'options'       => tonda_select_get_font_weight_array()
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'textsimple',
				'name'          => '404_text_letter_spacing',
				'default_value' => '',
				'label'         => esc_html__( 'Letter Spacing', 'tonda' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_text_text_transform',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'tonda' ),
				'options'       => tonda_select_get_text_transform_array()
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'      => $panel_404_options,
				'type'        => 'text',
				'name'        => '404_back_to_home',
				'label'       => esc_html__( 'Back to Home Button Label', 'tonda' ),
				'description' => esc_html__( 'Enter label for "Back to home" button', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'select',
				'name'          => '404_button_style',
				'default_value' => '',
				'label'         => esc_html__( 'Button Skin', 'tonda' ),
				'description'   => esc_html__( 'Choose a style to make Back to Home button in that predefined style', 'tonda' ),
				'options'       => array(
					''            => esc_html__( 'Default', 'tonda' ),
					'light-style' => esc_html__( 'Light', 'tonda' )
				)
			)
		);
	}
	
	add_action( 'tonda_select_action_options_map', 'tonda_select_error_404_options_map', 19 );
}