<?php
$image_proportion       = tonda_select_get_meta_field_intersect( 'blog_list_featured_image_proportion', tonda_select_get_page_id() );
$image_proportion_value = get_post_meta( get_the_ID(), 'qodef_blog_masonry_gallery_' . $image_proportion . '_dimensions_meta', true );

if ( isset( $image_proportion_value ) && $image_proportion_value !== '' ) {
	$size           = $image_proportion_value !== '' ? $image_proportion_value : 'default';
	$post_classes[] = 'qodef-masonry-size-' . $size;
} else {
	$size           = 'default';
	$post_classes[] = 'qodef-masonry-size-small';
}

if ( $image_proportion == 'original' ) {
	$part_params['image_size'] = 'full';
} else {
	switch ( $size ):
		case 'default':
			$part_params['image_size'] = 'tonda_select_image_square';
			break;
		case 'large-width':
			$part_params['image_size'] = 'tonda_select_image_landscape';
			break;
		case 'large-height':
			$part_params['image_size'] = 'tonda_select_image_portrait';
			break;
		case 'large-width-height':
			$part_params['image_size'] = 'tonda_select_image_huge';
			break;
		default:
			$part_params['image_size'] = 'tonda_select_image_square';
			break;
	endswitch;
}

$post_classes[] = 'qodef-item-space';
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?>>
	<div class="qodef-post-content">
        <div class="qodef-post-heading">
	        <?php if ( has_post_thumbnail() ) { ?>
	            <?php tonda_select_get_module_template_part('templates/parts/media', 'blog', 'list-' . $post_format, $part_params); ?>
		        <div class="qodef-post-heading-text">
			        <?php tonda_select_get_module_template_part('templates/parts/post-info/category', 'blog', '', $part_params); ?>
			        <?php tonda_select_get_module_template_part('templates/parts/title', 'blog', '', $part_params); ?>
                    <?php tonda_select_get_module_template_part('templates/parts/post-info/author', 'blog', '', $part_params); ?>
		        </div>
	        <?php } ?>
        </div>
	    <?php if ( ! has_post_thumbnail() ) { ?>
	        <div class="qodef-post-text">
	            <div class="qodef-post-text-inner">
		            <div class="qodef-post-info-top">
	                    <?php tonda_select_get_module_template_part('templates/parts/post-info/category', 'blog', '', $part_params); ?>
	                </div>
	                <div class="qodef-post-text-main">
	                    <?php tonda_select_get_module_template_part('templates/parts/title', 'blog', '', $part_params); ?>
	                </div>
		            <div class="qodef-post-info-bottom clearfix">
			            <div class="qodef-post-info-bottom-left">
				            <?php tonda_select_get_module_template_part('templates/parts/post-info/author', 'blog', '', $part_params); ?>
			            </div>
		            </div>
	            </div>
	        </div>
	    <?php } ?>
    </div>
</article>