(function($) {
    "use strict";

    var blogMasonryGallery = {};
    qodef.modules.blogMasonryGallery = blogMasonryGallery;

    blogMasonryGallery.qodefOnDocumentReady = qodefOnDocumentReady;
    blogMasonryGallery.qodefOnWindowLoad = qodefOnWindowLoad;

    $(document).ready(qodefOnDocumentReady);
    $(window).on('load', qodefOnWindowLoad);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function qodefOnDocumentReady() {
        qodefInitBlogMasonryGalleryAppearLoadMore();
    }

    /*
     All functions to be called on $(window).on('load', ) should be in this function
     */
    function qodefOnWindowLoad() {
        qodefInitBlogMasonryGalleryAppear();
    }

    /**
     *  Animate blog masonry gallery type
     */
    function qodefInitBlogMasonryGalleryAppear() {
        var blogList = $('.qodef-blog-holder.qodef-blog-masonry-gallery');
        
        if(blogList.length){
            blogList.each(function(){
                var thisBlogList = $(this),
                    article = thisBlogList.find('article'),
                    pagination = thisBlogList.find('.qodef-blog-pagination-holder'),
                    animateCycle = 7, // rewind delay
                    animateCycleCounter = 0;

                article.each(function(){
                    var thisArticle = $(this);
                    
                    setTimeout(function(){
                        thisArticle.appear(function(){
                            animateCycleCounter ++;
                            
                            if(animateCycleCounter === animateCycle) {
                                animateCycleCounter = 0;
                            }
                            
                            setTimeout(function(){
                                thisArticle.addClass('qodef-appeared');
                            },animateCycleCounter * 200);
                        },{accX: 0, accY: 0});
                    },150);
                });

                pagination.appear(function(){
                    pagination.addClass('qodef-appeared');
                },{accX: 0, accY: qodefGlobalVars.vars.qodefElementAppearAmount});
            });
        }
    }

    function qodefInitBlogMasonryGalleryAppearLoadMore() {
        $( document.body ).on( 'blog_list_load_more_trigger', function() {
            qodefInitBlogMasonryGalleryAppear();
        });
    }

})(jQuery);