<?php

if ( ! function_exists( 'tonda_select_include_blog_shortcodes' ) ) {
	function tonda_select_include_blog_shortcodes() {
		include_once SELECT_FRAMEWORK_MODULES_ROOT_DIR . '/blog/shortcodes/blog-list/blog-list.php';
	}
	
	if ( tonda_select_core_plugin_installed() ) {
		add_action( 'tonda_core_action_include_shortcodes_file', 'tonda_select_include_blog_shortcodes' );
	}
}

if ( ! function_exists( 'tonda_select_add_blog_shortcodes' ) ) {
	function tonda_select_add_blog_shortcodes( $shortcodes_class_name ) {
		$shortcodes = array(
			'TondaCore\CPT\Shortcodes\BlogList\BlogList'
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	if ( tonda_select_core_plugin_installed() ) {
		add_filter( 'tonda_core_filter_add_vc_shortcode', 'tonda_select_add_blog_shortcodes' );
	}
}

if ( ! function_exists( 'tonda_select_set_blog_list_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for blog shortcodes to set our icon for Visual Composer shortcodes panel
	 */
	function tonda_select_set_blog_list_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-blog-list';
		
		return $shortcodes_icon_class_array;
	}
	
	if ( tonda_select_core_plugin_installed() ) {
		add_filter( 'tonda_core_filter_add_vc_shortcodes_custom_icon_class', 'tonda_select_set_blog_list_icon_class_name_for_vc_shortcodes' );
	}
}