<?php

/*** Post Settings ***/

if ( ! function_exists( 'tonda_select_map_post_meta' ) ) {
	function tonda_select_map_post_meta() {
		
		$post_meta_box = tonda_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Post', 'tonda' ),
				'name'  => 'post-meta'
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_blog_single_sidebar_layout_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout', 'tonda' ),
				'description'   => esc_html__( 'Choose a sidebar layout for Blog single page', 'tonda' ),
				'default_value' => '',
				'parent'        => $post_meta_box,
                'options'       => tonda_select_get_custom_sidebars_options( true )
			)
		);
		
		$tonda_custom_sidebars = tonda_select_get_custom_sidebars();
		if ( count( $tonda_custom_sidebars ) > 0 ) {
			tonda_select_create_meta_box_field( array(
				'name'        => 'qodef_blog_single_custom_sidebar_area_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'tonda' ),
				'description' => esc_html__( 'Choose a sidebar to display on Blog single page. Default sidebar is "Sidebar"', 'tonda' ),
				'parent'      => $post_meta_box,
				'options'     => tonda_select_get_custom_sidebars(),
				'args' => array(
					'select2' => true
				)
			) );
		}
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_blog_list_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Blog List Image', 'tonda' ),
				'description' => esc_html__( 'Choose an Image for displaying in blog list. If not uploaded, featured image will be shown.', 'tonda' ),
				'parent'      => $post_meta_box
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_blog_masonry_gallery_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Fixed Proportion', 'tonda' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry lists in fixed proportion', 'tonda' ),
				'default_value' => 'small',
				'parent'        => $post_meta_box,
				'options'       => array(
					'small'              => esc_html__( 'Small', 'tonda' ),
					'large-width'        => esc_html__( 'Large Width', 'tonda' ),
					'large-height'       => esc_html__( 'Large Height', 'tonda' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'tonda' )
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_blog_masonry_gallery_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Original Proportion', 'tonda' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry lists in original proportion', 'tonda' ),
				'default_value' => 'default',
				'parent'        => $post_meta_box,
				'options'       => array(
					'default'     => esc_html__( 'Default', 'tonda' ),
					'large-width' => esc_html__( 'Large Width', 'tonda' )
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_blog_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'tonda' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single post page', 'tonda' ),
				'parent'        => $post_meta_box,
				'options'       => tonda_select_get_yes_no_select_array()
			)
		);

		do_action('tonda_select_action_blog_post_meta', $post_meta_box);
	}
	
	add_action( 'tonda_select_action_meta_boxes_map', 'tonda_select_map_post_meta', 20 );
}
