<?php

if ( ! function_exists( 'tonda_select_map_post_video_meta' ) ) {
	function tonda_select_map_post_video_meta() {
		$video_post_format_meta_box = tonda_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'tonda' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'tonda' ),
				'description'   => esc_html__( 'Choose video type', 'tonda' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'tonda' ),
					'self'            => esc_html__( 'Self Hosted', 'tonda' )
				)
			)
		);
		
		$qodef_video_embedded_container = tonda_select_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'qodef_video_embedded_container'
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'tonda' ),
				'description' => esc_html__( 'Enter Video URL', 'tonda' ),
				'parent'      => $qodef_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'tonda' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'tonda' ),
				'parent'      => $qodef_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_video_type_meta' => 'self'
					)
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'tonda' ),
				'description' => esc_html__( 'Enter video image', 'tonda' ),
				'parent'      => $qodef_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'tonda_select_action_meta_boxes_map', 'tonda_select_map_post_video_meta', 22 );
}