<?php

if ( ! function_exists( 'tonda_select_map_post_audio_meta' ) ) {
	function tonda_select_map_post_audio_meta() {
		$audio_post_format_meta_box = tonda_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'tonda' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'tonda' ),
				'description'   => esc_html__( 'Choose audio type', 'tonda' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'tonda' ),
					'self'            => esc_html__( 'Self Hosted', 'tonda' )
				)
			)
		);
		
		$qodef_audio_embedded_container = tonda_select_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'qodef_audio_embedded_container'
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'tonda' ),
				'description' => esc_html__( 'Enter audio URL', 'tonda' ),
				'parent'      => $qodef_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'tonda' ),
				'description' => esc_html__( 'Enter audio link', 'tonda' ),
				'parent'      => $qodef_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'tonda_select_action_meta_boxes_map', 'tonda_select_map_post_audio_meta', 23 );
}