<?php

foreach ( glob( SELECT_FRAMEWORK_MODULES_ROOT_DIR . '/blog/admin/meta-boxes/*/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'tonda_select_map_blog_meta' ) ) {
	function tonda_select_map_blog_meta() {
		$qodef_blog_categories = array();
		$categories           = get_categories();
		foreach ( $categories as $category ) {
			$qodef_blog_categories[ $category->slug ] = $category->name;
		}
		
		$blog_meta_box = tonda_select_create_meta_box(
			array(
				'scope' => array( 'page' ),
				'title' => esc_html__( 'Blog', 'tonda' ),
				'name'  => 'blog_meta'
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_blog_category_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Blog Category', 'tonda' ),
				'description' => esc_html__( 'Choose category of posts to display (leave empty to display all categories)', 'tonda' ),
				'parent'      => $blog_meta_box,
				'options'     => $qodef_blog_categories
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_show_posts_per_page_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Posts', 'tonda' ),
				'description' => esc_html__( 'Enter the number of posts to display', 'tonda' ),
				'parent'      => $blog_meta_box,
				'options'     => $qodef_blog_categories,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_blog_masonry_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Layout', 'tonda' ),
				'description' => esc_html__( 'Set masonry layout. Default is in grid.', 'tonda' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''           => esc_html__( 'Default', 'tonda' ),
					'in-grid'    => esc_html__( 'In Grid', 'tonda' ),
					'full-width' => esc_html__( 'Full Width', 'tonda' )
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_blog_masonry_number_of_columns_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Number of Columns', 'tonda' ),
				'description' => esc_html__( 'Set number of columns for your masonry blog lists', 'tonda' ),
				'parent'      => $blog_meta_box,
				'options'     => array(
					''      => esc_html__( 'Default', 'tonda' ),
					'two'   => esc_html__( '2 Columns', 'tonda' ),
					'three' => esc_html__( '3 Columns', 'tonda' ),
					'four'  => esc_html__( '4 Columns', 'tonda' ),
					'five'  => esc_html__( '5 Columns', 'tonda' )
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_blog_masonry_space_between_items_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Masonry - Space Between Items', 'tonda' ),
				'description' => esc_html__( 'Set space size between posts for your masonry blog lists', 'tonda' ),
				'options'     => tonda_select_get_space_between_items_array( true ),
				'parent'      => $blog_meta_box
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_blog_list_featured_image_proportion_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Masonry - Featured Image Proportion', 'tonda' ),
				'description'   => esc_html__( 'Choose type of proportions you want to use for featured images on masonry blog lists', 'tonda' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''         => esc_html__( 'Default', 'tonda' ),
					'fixed'    => esc_html__( 'Fixed', 'tonda' ),
					'original' => esc_html__( 'Original', 'tonda' )
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_blog_pagination_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Pagination Type', 'tonda' ),
				'description'   => esc_html__( 'Choose a pagination layout for Blog Lists', 'tonda' ),
				'parent'        => $blog_meta_box,
				'default_value' => '',
				'options'       => array(
					''                => esc_html__( 'Default', 'tonda' ),
					'standard'        => esc_html__( 'Standard', 'tonda' ),
					'load-more'       => esc_html__( 'Load More', 'tonda' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'tonda' ),
					'no-pagination'   => esc_html__( 'No Pagination', 'tonda' )
				)
			)
		);
		
		tonda_select_create_meta_box_field(
			array(
				'type'          => 'text',
				'name'          => 'qodef_number_of_chars_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Number of Words in Excerpt', 'tonda' ),
				'description'   => esc_html__( 'Enter a number of words in excerpt (article summary). Default value is 40', 'tonda' ),
				'parent'        => $blog_meta_box,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'tonda_select_action_meta_boxes_map', 'tonda_select_map_blog_meta', 30 );
}