<?php

if ( ! function_exists( 'tonda_select_reset_options_map' ) ) {
	/**
	 * Reset options panel
	 */
	function tonda_select_reset_options_map() {
		
		tonda_select_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__( 'Reset', 'tonda' ),
				'icon'  => 'fa fa-retweet'
			)
		);
		
		$panel_reset = tonda_select_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__( 'Reset', 'tonda' )
			)
		);
		
		tonda_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'reset_to_defaults',
				'default_value' => 'no',
				'label'         => esc_html__( 'Reset to Defaults', 'tonda' ),
				'description'   => esc_html__( 'This option will reset all Select Options values to defaults', 'tonda' ),
				'parent'        => $panel_reset
			)
		);
	}
	
	add_action( 'tonda_select_action_options_map', 'tonda_select_reset_options_map', 100 );
}