<?php

if ( ! function_exists( 'tonda_select_map_general_meta' ) ) {
	function tonda_select_map_general_meta() {
		
		$general_meta_box = tonda_select_create_meta_box(
			array(
				'scope' => apply_filters( 'tonda_select_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'general_meta' ),
				'title' => esc_html__( 'General', 'tonda' ),
				'name'  => 'general_meta'
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_slider_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Slider Shortcode', 'tonda' ),
				'description' => esc_html__( 'Paste your slider shortcode here', 'tonda' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		/***************** Content Layout - begin **********************/
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_page_content_behind_header_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Always put content behind header', 'tonda' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'tonda' ),
				'parent'        => $general_meta_box
			)
		);
		
		$qodef_content_padding_group = tonda_select_add_admin_group(
			array(
				'name'        => 'content_padding_group',
				'title'       => esc_html__( 'Content Style', 'tonda' ),
				'description' => esc_html__( 'Define styles for Content area', 'tonda' ),
				'parent'      => $general_meta_box
			)
		);
		
			$qodef_content_padding_row = tonda_select_add_admin_row(
				array(
					'name'   => 'qodef_content_padding_row',
					'next'   => true,
					'parent' => $qodef_content_padding_group
				)
			);
		
				tonda_select_create_meta_box_field(
					array(
						'name'   => 'qodef_page_content_padding',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Content Padding (e.g. 10px 5px 10px 5px)', 'tonda' ),
						'parent' => $qodef_content_padding_row,
					)
				);
				
				tonda_select_create_meta_box_field(
					array(
						'name'    => 'qodef_page_content_padding_mobile',
						'type'    => 'textsimple',
						'label'   => esc_html__( 'Content Padding for mobile (e.g. 10px 5px 10px 5px)', 'tonda' ),
						'parent'  => $qodef_content_padding_row,
					)
				);
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Page Background Color', 'tonda' ),
				'description' => esc_html__( 'Choose background color for page content', 'tonda' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Content Layout - end **********************/
		
		/***************** Boxed Layout - begin **********************/
		
		tonda_select_create_meta_box_field(
			array(
				'name'    => 'qodef_boxed_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Boxed Layout', 'tonda' ),
				'parent'  => $general_meta_box,
				'options' => tonda_select_get_yes_no_select_array()
			)
		);
		
			$boxed_container_meta = tonda_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'boxed_container_meta',
					'dependency' => array(
						'hide' => array(
							'qodef_boxed_meta'  => array('','no')
						)
					)
				)
			);
		
				tonda_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_background_color_in_box_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'tonda' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'tonda' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				tonda_select_create_meta_box_field(
					array(
						'name'        => 'qodef_boxed_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'tonda' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'tonda' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				tonda_select_create_meta_box_field(
					array(
						'name'        => 'qodef_boxed_pattern_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'tonda' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'tonda' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				tonda_select_create_meta_box_field(
					array(
						'name'          => 'qodef_boxed_background_image_attachment_meta',
						'type'          => 'select',
						'default_value' => 'fixed',
						'label'         => esc_html__( 'Background Image Attachment', 'tonda' ),
						'description'   => esc_html__( 'Choose background image attachment', 'tonda' ),
						'parent'        => $boxed_container_meta,
						'options'       => array(
							''       => esc_html__( 'Default', 'tonda' ),
							'fixed'  => esc_html__( 'Fixed', 'tonda' ),
							'scroll' => esc_html__( 'Scroll', 'tonda' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_paspartu_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Passepartout', 'tonda' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'tonda' ),
				'parent'        => $general_meta_box,
				'options'       => tonda_select_get_yes_no_select_array(),
			)
		);
		
			$paspartu_container_meta = tonda_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'qodef_paspartu_container_meta',
					'dependency' => array(
						'hide' => array(
							'qodef_paspartu_meta'  => array('','no')
						)
					)
				)
			);
		
				tonda_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'tonda' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'tonda' ),
						'parent'      => $paspartu_container_meta
					)
				);
				
				tonda_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'tonda' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'tonda' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				tonda_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_responsive_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'tonda' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'tonda' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				tonda_select_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'qodef_disable_top_paspartu_meta',
						'label'         => esc_html__( 'Disable Top Passepartout', 'tonda' ),
						'options'       => tonda_select_get_yes_no_select_array(),
					)
				);
		
				tonda_select_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'qodef_enable_fixed_paspartu_meta',
						'label'         => esc_html__( 'Enable Fixed Passepartout', 'tonda' ),
						'description'   => esc_html__( 'Enabling this option will set fixed passepartout for your screens', 'tonda' ),
						'options'       => tonda_select_get_yes_no_select_array(),
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Content Width Layout - begin **********************/
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_initial_content_width_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'tonda' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'tonda' ),
				'parent'        => $general_meta_box,
				'options'       => array(
					''                => esc_html__( 'Default', 'tonda' ),
					'qodef-grid-1100' => esc_html__( '1100px', 'tonda' ),
					'qodef-grid-1300' => esc_html__( '1300px', 'tonda' ),
					'qodef-grid-1200' => esc_html__( '1200px', 'tonda' ),
					'qodef-grid-1000' => esc_html__( '1000px', 'tonda' ),
					'qodef-grid-800'  => esc_html__( '800px', 'tonda' )
				)
			)
		);
		
		/***************** Content Width Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		tonda_select_create_meta_box_field(
			array(
				'name'          => 'qodef_smooth_page_transitions_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Smooth Page Transitions', 'tonda' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'tonda' ),
				'parent'        => $general_meta_box,
				'options'       => tonda_select_get_yes_no_select_array()
			)
		);
		
			$page_transitions_container_meta = tonda_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'page_transitions_container_meta',
					'dependency' => array(
						'hide' => array(
							'qodef_smooth_page_transitions_meta'  => array('','no')
						)
					)
				)
			);
		
				tonda_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_transition_preloader_meta',
						'type'        => 'select',
						'label'       => esc_html__( 'Enable Preloading Animation', 'tonda' ),
						'description' => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'tonda' ),
						'parent'      => $page_transitions_container_meta,
						'options'     => tonda_select_get_yes_no_select_array()
					)
				);
				
				$page_transition_preloader_container_meta = tonda_select_add_admin_container(
					array(
						'parent'          => $page_transitions_container_meta,
						'name'            => 'page_transition_preloader_container_meta',
						'dependency' => array(
							'hide' => array(
								'qodef_page_transition_preloader_meta'  => array('','no')
							)
						)
					)
				);
				
					tonda_select_create_meta_box_field(
						array(
							'name'   => 'qodef_smooth_pt_bgnd_color_meta',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'tonda' ),
							'parent' => $page_transition_preloader_container_meta
						)
					);
					
					$group_pt_spinner_animation_meta = tonda_select_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation_meta',
							'title'       => esc_html__( 'Loader Style', 'tonda' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'tonda' ),
							'parent'      => $page_transition_preloader_container_meta
						)
					);
					
					$row_pt_spinner_animation_meta = tonda_select_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation_meta',
							'parent' => $group_pt_spinner_animation_meta
						)
					);
					
					tonda_select_create_meta_box_field(
						array(
							'type'    => 'selectsimple',
							'name'    => 'qodef_smooth_pt_spinner_type_meta',
							'label'   => esc_html__( 'Spinner Type', 'tonda' ),
							'parent'  => $row_pt_spinner_animation_meta,
							'options' => array(
								''                      => esc_html__( 'Default', 'tonda' ),
								'tonda_preloader'       => esc_html__( 'Tonda Preloader', 'tonda' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'tonda' ),
								'pulse'                 => esc_html__( 'Pulse', 'tonda' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'tonda' ),
								'cube'                  => esc_html__( 'Cube', 'tonda' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'tonda' ),
								'stripes'               => esc_html__( 'Stripes', 'tonda' ),
								'wave'                  => esc_html__( 'Wave', 'tonda' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'tonda' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'tonda' ),
								'atom'                  => esc_html__( 'Atom', 'tonda' ),
								'clock'                 => esc_html__( 'Clock', 'tonda' ),
								'mitosis'               => esc_html__( 'Mitosis', 'tonda' ),
								'lines'                 => esc_html__( 'Lines', 'tonda' ),
								'fussion'               => esc_html__( 'Fussion', 'tonda' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'tonda' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'tonda' )
							)
						)
					);
					
					tonda_select_create_meta_box_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'qodef_smooth_pt_spinner_color_meta',
							'label'  => esc_html__( 'Spinner Color', 'tonda' ),
							'parent' => $row_pt_spinner_animation_meta
						)
					);
					
					tonda_select_create_meta_box_field(
						array(
							'name'        => 'qodef_page_transition_fadeout_meta',
							'type'        => 'select',
							'label'       => esc_html__( 'Enable Fade Out Animation', 'tonda' ),
							'description' => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'tonda' ),
							'options'     => tonda_select_get_yes_no_select_array(),
							'parent'      => $page_transitions_container_meta
						
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		/***************** Comments Layout - begin **********************/
		
		tonda_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_comments_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Comments', 'tonda' ),
				'description' => esc_html__( 'Enabling this option will show comments on your page', 'tonda' ),
				'parent'      => $general_meta_box,
				'options'     => tonda_select_get_yes_no_select_array()
			)
		);
		
		/***************** Comments Layout - end **********************/
	}
	
	add_action( 'tonda_select_action_meta_boxes_map', 'tonda_select_map_general_meta', 10 );
}