<?php

if(!function_exists('tonda_select_design_styles')) {
    /**
     * Generates general custom styles
     */
    function tonda_select_design_styles() {
	    $font_family = tonda_select_options()->getOptionValue( 'google_fonts' );
	    if ( ! empty( $font_family ) && tonda_select_is_font_option_valid( $font_family ) ) {
		    $font_family_selector = array(
			    'body'
		    );
		    echo tonda_select_dynamic_css( $font_family_selector, array( 'font-family' => tonda_select_get_font_option_val( $font_family ) ) );
	    }

		$first_main_color = tonda_select_options()->getOptionValue('first_color');
        if(!empty($first_main_color)) {
            $color_selector = array(
	            '.qodef-page-footer .widget.qodef-blog-list-widget .qodef-post-info-author-link:hover',
	            '.qodef-page-footer .widget a:hover',
	            '.qodef-page-footer .widget.widget_rss .qodef-widget-title .rsswidget:hover',
	            '.qodef-page-footer .widget.widget_search button:hover',
	            '.qodef-top-bar a:hover',
	            '.qodef-page-footer .widget.widget_qodef_twitter_widget .qodef-twitter-widget .owl-nav .owl-next:hover',
	            '.qodef-page-footer .widget.widget_qodef_twitter_widget .qodef-twitter-widget .owl-nav .owl-prev:hover',
	            '.qodef-page-footer .widget.widget_qodef_twitter_widget .qodef-twitter-widget li .qodef-tweet-text a:hover',
	            '.widget_icl_lang_sel_widget .wpml-ls-legacy-dropdown .wpml-ls-item-toggle:hover',
	            '.widget_icl_lang_sel_widget .wpml-ls-legacy-dropdown-click .wpml-ls-item-toggle:hover',
	            '.qodef-blog-holder article.format-link .qodef-post-mark .qodef-link-mark',
	            '.qodef-blog-holder article.format-quote .qodef-post-mark',
	            '.qodef-author-description .qodef-author-description-text-holder .qodef-author-name a:hover',
	            '.qodef-author-description .qodef-author-description-text-holder .qodef-author-social-icons a:hover',
	            '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-main-menu>ul>li.qodef-active-item>a',
	            '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-main-menu>ul>li>a:hover',
	            '.qodef-dark-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-fullscreen-menu-opener.qodef-fm-opened',
	            '.qodef-dark-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-fullscreen-menu-opener:hover',
	            '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-fullscreen-menu-opener.qodef-fm-opened',
	            '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-fullscreen-menu-opener:hover',
	            '.qodef-mobile-header .qodef-mobile-menu-opener.qodef-mobile-menu-opened a',
	            '.qodef-mobile-header .qodef-mobile-nav .qodef-grid>ul>li.qodef-active-item>a',
	            '.qodef-mobile-header .qodef-mobile-nav .qodef-grid>ul>li.qodef-active-item>h6',
	            '.qodef-mobile-header .qodef-mobile-nav ul li a:hover',
	            '.qodef-mobile-header .qodef-mobile-nav ul li h6:hover',
	            '.qodef-mobile-header .qodef-mobile-nav ul ul li.current-menu-ancestor>a',
	            '.qodef-mobile-header .qodef-mobile-nav ul ul li.current-menu-ancestor>h6',
	            '.qodef-mobile-header .qodef-mobile-nav ul ul li.current-menu-item>a',
	            '.qodef-mobile-header .qodef-mobile-nav ul ul li.current-menu-item>h6',
	            '.qodef-popup-holder .qodef-popup-close:hover',
	            '.qodef-search-page-holder article.sticky .qodef-post-title a',
	            '.qodef-pl-standard-pagination ul li.qodef-pl-pag-active a',
	            '.qodef-portfolio-list-holder.qodef-pl-gallery-overlay article .qodef-pli-text .qodef-pli-category-holder a:hover',
	            '.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.qodef-nav-light-skin .owl-nav .owl-next:hover',
	            '.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.qodef-nav-light-skin .owl-nav .owl-prev:hover',
	            '.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.qodef-nav-dark-skin .owl-nav .owl-next:hover',
	            '.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.qodef-nav-dark-skin .owl-nav .owl-prev:hover',
	            '.qodef-reviews-per-criteria .qodef-item-reviews-average-rating',
	            '.qodef-banner-holder .qodef-banner-link-text .qodef-banner-link-hover span',
	            '.qodef-social-share-holder.qodef-dropdown .qodef-social-share-dropdown-opener:hover',
	            '.qodef-video-button-holder .qodef-video-button-play:hover .qodef-video-button-triangle',
	            '.qodef-twitter-list-holder .qodef-twitter-icon',
	            '.qodef-twitter-list-holder .qodef-tweet-text a:hover',
	            '.qodef-twitter-list-holder .qodef-twitter-profile a:hover'
            );

            $woo_color_selector = array();
            if(tonda_select_is_woocommerce_installed()) {
                $woo_color_selector = array(
	                '.woocommerce-page .qodef-content .qodef-quantity-buttons .qodef-quantity-minus:hover',
	                '.woocommerce-page .qodef-content .qodef-quantity-buttons .qodef-quantity-plus:hover',
	                'div.woocommerce .qodef-quantity-buttons .qodef-quantity-minus:hover',
	                'div.woocommerce .qodef-quantity-buttons .qodef-quantity-plus:hover',
	                'div.woocommerce>.single-product .qodef-single-product-summary .product_meta>span a:hover',
	                '.qodef-dark-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-shopping-cart-holder .qodef-header-cart:hover',
	                '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-shopping-cart-holder .qodef-header-cart:hover',
	                '.qodef-product-banner.qodef-product-banner-dark .qodef-product-banner-categories a:hover',
	                '.qodef-product-banner.qodef-product-banner-dark .qodef-product-banner-price a:hover',
	                '.qodef-product-banner.qodef-product-banner-dark .qodef-product-banner-title a:hover',
	                '#yith-quick-view-modal #yith-quick-view-content .summary .qodef-single-product-share-wish .yith-wcwl-wishlistaddedbrowse a:after',
	                '#yith-quick-view-modal #yith-quick-view-content .summary .qodef-single-product-share-wish .yith-wcwl-wishlistexistsbrowse a:after',
	                '.yith-quick-view.yith-modal #yith-quick-view-content .summary .qodef-single-product-share-wish .yith-wcwl-wishlistaddedbrowse a:after',
	                '.yith-quick-view.yith-modal #yith-quick-view-content .summary .qodef-single-product-share-wish .yith-wcwl-wishlistexistsbrowse a:after',
	                '#yith-quick-view-modal #yith-quick-view-content .summary .qodef-single-product-share-wish .qodef-woo-social-share-holder>span',
	                '.yith-quick-view.yith-modal #yith-quick-view-content .summary .qodef-single-product-share-wish .qodef-woo-social-share-holder>span'
                );
            }

            $color_selector = array_merge($color_selector, $woo_color_selector);

	        $color_important_selector = array(
		        '.qodef-dark-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-icon-widget-holder:hover',
		        '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-icon-widget-holder:hover',
		        '.qodef-dark-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-social-icon-widget-holder:hover',
		        '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-social-icon-widget-holder:hover',
		        '.qodef-light-header .qodef-page-header>div:not(.fixed):not(.qodef-sticky-header) .qodef-menu-area .widget a:hover',
		        '.qodef-light-header .qodef-page-header>div:not(.fixed):not(.qodef-sticky-header).qodef-menu-area .widget a:hover',
		        '.qodef-dark-header .qodef-page-header>div:not(.fixed):not(.qodef-sticky-header) .qodef-menu-area .widget a:hover',
		        '.qodef-dark-header .qodef-page-header>div:not(.fixed):not(.qodef-sticky-header).qodef-menu-area .widget a:hover',
		        '.qodef-light-header.qodef-header-vertical .qodef-vertical-menu ul li a:hover',
		        '.qodef-light-header.qodef-header-vertical .qodef-vertical-menu ul li ul li.current-menu-ancestor>a',
		        '.qodef-light-header.qodef-header-vertical .qodef-vertical-menu ul li ul li.current-menu-item>a',
		        '.qodef-light-header.qodef-header-vertical .qodef-vertical-menu ul li ul li.current_page_item>a',
		        '.qodef-light-header.qodef-header-vertical .qodef-vertical-menu>ul>li.current-menu-ancestor>a',
		        '.qodef-light-header.qodef-header-vertical .qodef-vertical-menu>ul>li.qodef-active-item>a',
		        '.qodef-dark-header.qodef-header-vertical .qodef-vertical-menu ul li a:hover',
		        '.qodef-dark-header.qodef-header-vertical .qodef-vertical-menu ul li ul li.current-menu-ancestor>a',
		        '.qodef-dark-header.qodef-header-vertical .qodef-vertical-menu ul li ul li.current-menu-item>a',
		        '.qodef-dark-header.qodef-header-vertical .qodef-vertical-menu ul li ul li.current_page_item>a',
		        '.qodef-dark-header.qodef-header-vertical .qodef-vertical-menu>ul>li.current-menu-ancestor>a',
		        '.qodef-dark-header.qodef-header-vertical .qodef-vertical-menu>ul>li.qodef-active-item>a',
		        '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-search-opener:hover',
		        '.qodef-light-header .qodef-top-bar .qodef-search-opener:hover',
		        '.qodef-dark-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-search-opener:hover',
		        '.qodef-dark-header .qodef-top-bar .qodef-search-opener:hover',
		        '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-side-menu-button-opener.opened',
		        '.qodef-light-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-side-menu-button-opener:hover',
		        '.qodef-light-header .qodef-top-bar .qodef-side-menu-button-opener.opened',
		        '.qodef-light-header .qodef-top-bar .qodef-side-menu-button-opener:hover',
		        '.qodef-dark-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-side-menu-button-opener.opened',
		        '.qodef-dark-header .qodef-page-header>div:not(.qodef-sticky-header):not(.fixed) .qodef-side-menu-button-opener:hover',
		        '.qodef-dark-header .qodef-top-bar .qodef-side-menu-button-opener.opened',
		        '.qodef-dark-header .qodef-top-bar .qodef-side-menu-button-opener:hover'
	        );

            $background_color_selector = array(
	            '.qodef-st-loader .pulse',
	            '.qodef-st-loader .double_pulse .double-bounce1',
	            '.qodef-st-loader .double_pulse .double-bounce2',
	            '.qodef-st-loader .cube',
	            '.qodef-st-loader .rotating_cubes .cube1',
	            '.qodef-st-loader .rotating_cubes .cube2',
	            '.qodef-st-loader .stripes>div',
	            '.qodef-st-loader .wave>div',
	            '.qodef-st-loader .two_rotating_circles .dot1',
	            '.qodef-st-loader .two_rotating_circles .dot2',
	            '.qodef-st-loader .five_rotating_circles .container1>div',
	            '.qodef-st-loader .five_rotating_circles .container2>div',
	            '.qodef-st-loader .five_rotating_circles .container3>div',
	            '.qodef-st-loader .atom .ball-1:before',
	            '.qodef-st-loader .atom .ball-2:before',
	            '.qodef-st-loader .atom .ball-3:before',
	            '.qodef-st-loader .atom .ball-4:before',
	            '.qodef-st-loader .clock .ball:before',
	            '.qodef-st-loader .mitosis .ball',
	            '.qodef-st-loader .lines .line1',
	            '.qodef-st-loader .lines .line2',
	            '.qodef-st-loader .lines .line3',
	            '.qodef-st-loader .lines .line4',
	            '.qodef-st-loader .fussion .ball',
	            '.qodef-st-loader .fussion .ball-1',
	            '.qodef-st-loader .fussion .ball-2',
	            '.qodef-st-loader .fussion .ball-3',
	            '.qodef-st-loader .fussion .ball-4',
	            '.qodef-st-loader .wave_circles .ball',
	            '.qodef-st-loader .pulse_circles .ball',
	            '#submit_comment',
	            '.post-password-form input[type=submit]',
	            'input.wpcf7-form-control.wpcf7-submit',
	            '.qodef-cf7-btn-wrapper .qodef-cf7-btn-inner',
	            '.qodef-cf7-btn-wrapper .post-password-form input[type=submit]:hover',
	            '.qodef-cf7-btn-wrapper input.wpcf7-form-control.wpcf7-submit:hover',
	            '#qodef-back-to-top .qodef-btt-bgrnd-holder',
	            '.qodef-social-icons-group-widget.qodef-square-icons .qodef-social-icon-widget-holder:hover',
	            '.qodef-social-icons-group-widget.qodef-square-icons.qodef-light-skin .qodef-social-icon-widget-holder:hover',
	            '.qodef-blog-holder article.format-link .qodef-post-text',
	            '.qodef-blog-holder article.format-quote .qodef-post-text',
	            '.qodef-blog-holder article.format-audio .qodef-blog-audio-holder .mejs-container .mejs-controls>.mejs-playpause-button',
	            '.qodef-blog-holder article.format-audio .qodef-blog-audio-holder .mejs-container .mejs-controls>.mejs-time-rail .mejs-time-total .mejs-time-current',
	            '.qodef-blog-holder article.format-audio .qodef-blog-audio-holder .mejs-container .mejs-controls>a.mejs-horizontal-volume-slider .mejs-horizontal-volume-current',
	            '.qodef-blog-pagination ul li a:after',
	            '.qodef-bl-standard-pagination ul li a:after',
	            '.qodef-author-description',
	            '.qodef-main-menu>ul>li>a>span.item_outer .item_text:before',
	            '.qodef-drop-down .second .inner ul li a .item_outer:before',
	            'nav.qodef-fullscreen-menu ul li a span:before',
	            '.qodef-header-vertical .qodef-vertical-menu ul li a .item_outer:before',
	            '.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.qodef-pag-light-skin .owl-dots .owl-dot.active span',
	            '.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.qodef-pag-light-skin .owl-dots .owl-dot:hover span',
	            '.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.qodef-pag-dark-skin .owl-dots .owl-dot.active span',
	            '.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.qodef-pag-dark-skin .owl-dots .owl-dot:hover span',
	            '.qodef-btn.qodef-btn-simple:before',
	            '.qodef-btn.qodef-btn-solid',
	            '.qodef-icon-shortcode.qodef-circle',
	            '.qodef-icon-shortcode.qodef-dropcaps.qodef-circle',
	            '.qodef-icon-shortcode.qodef-square',
	            '.qodef-price-table.qodef-pt-active-item .qodef-pt-inner ul li.qodef-pt-button .qodef-btn.qodef-dir-aware-hover .qodef-btn-background',
	            '.qodef-progress-bar .qodef-pb-content-holder .qodef-pb-content',
	            '.qodef-login-register-widget.qodef-user-logged-in .qodef-login-dropdown li a:before'
            );

            $woo_background_color_selector = array();
            if(tonda_select_is_woocommerce_installed()) {
                $woo_background_color_selector = array(
	                '.qodef-woocommerce-page table.cart td.actions .coupon input[type=submit]:hover',
	                '.woocommerce-page .qodef-content .wc-forward:not(.added_to_cart):not(.checkout-button)',
	                '.woocommerce-page .qodef-content a.added_to_cart',
	                '.woocommerce-page .qodef-content a.button',
	                '.woocommerce-page .qodef-content button[type=submit]:not(.qodef-woo-search-widget-button)',
	                '.woocommerce-page .qodef-content input[type=submit]',
	                'div.woocommerce .wc-forward:not(.added_to_cart):not(.checkout-button)',
	                'div.woocommerce a.added_to_cart',
	                'div.woocommerce a.button',
	                'div.woocommerce button[type=submit]:not(.qodef-woo-search-widget-button)',
	                'div.woocommerce input[type=submit]',
	                '.woocommerce .qodef-new-product',
	                '.woocommerce .qodef-onsale',
	                '.woocommerce .qodef-out-of-stock',
	                '.woocommerce-pagination .page-numbers li a:after',
	                '.woocommerce-pagination .page-numbers li span:after',
	                '.qodef-shopping-cart-dropdown .qodef-cart-bottom .qodef-view-cart',
	                '.qodef-shopping-cart-dropdown .qodef-cart-bottom .qodef-view-checkout',
	                '.qodef-shopping-cart-dropdown .qodef-cart-bottom .qodef-view-cart:hover',
	                '.widget.woocommerce.widget_price_filter .price_slider_amount .button:before',
	                '.qodef-plc-holder .qodef-plc-new-product',
	                '.qodef-plc-holder .qodef-plc-onsale',
	                '.qodef-plc-holder .qodef-plc-out-of-stock',
	                '.qodef-pl-holder .qodef-pli-inner .qodef-pli-image .qodef-pli-new-product',
	                '.qodef-pl-holder .qodef-pli-inner .qodef-pli-image .qodef-pli-onsale',
	                '.qodef-pl-holder .qodef-pli-inner .qodef-pli-image .qodef-pli-out-of-stock',
	                '.qodef-plc-holder .qodef-pli-inner .qodef-pli-image .qodef-pli-new-product',
	                '.qodef-plc-holder .qodef-pli-inner .qodef-pli-image .qodef-pli-onsale',
	                '.qodef-plc-holder .qodef-pli-inner .qodef-pli-image .qodef-pli-out-of-stock',
	                '.woocommerce-wishlist table.wishlist_table tbody tr td.product-add-to-cart a'
                );
            }

            $background_color_selector = array_merge($background_color_selector, $woo_background_color_selector);
	
	        $background_color_important_selector = array(
		        '.error404 .qodef-page-not-found .qodef-btn.qodef-btn-light-style:hover',
		        '.qodef-price-table.qodef-pt-active-item .qodef-pt-inner ul li.qodef-pt-button .qodef-btn:not(.qodef-dir-aware-hover):hover'
	        );
	        
            $border_color_selector = array(
	            '.qodef-st-loader .pulse_circles .ball',
	            '.qodef-owl-slider+.qodef-slider-thumbnail>.qodef-slider-thumbnail-item.active img',
	            '.qodef-frame-video-holder.qodef-fv-with-outline .qodef-fv-outline'
            );
	
	        $border_color_important_selector = array(
		        '.error404 .qodef-page-not-found .qodef-btn.qodef-btn-light-style:hover'
	        );

            echo tonda_select_dynamic_css($color_selector, array('color' => $first_main_color));
	        echo tonda_select_dynamic_css($color_important_selector, array('color' => $first_main_color.'!important'));
	        echo tonda_select_dynamic_css($background_color_selector, array('background-color' => $first_main_color));
	        echo tonda_select_dynamic_css($background_color_important_selector, array('background-color' => $first_main_color.'!important'));
	        echo tonda_select_dynamic_css($border_color_selector, array('border-color' => $first_main_color));
	        echo tonda_select_dynamic_css($border_color_important_selector, array('border-color' => $first_main_color.'!important'));
        }
	
	    $page_background_color = tonda_select_options()->getOptionValue( 'page_background_color' );
	    if ( ! empty( $page_background_color ) ) {
		    $background_color_selector = array(
			    'body',
			    '.qodef-content'
		    );
		    echo tonda_select_dynamic_css( $background_color_selector, array( 'background-color' => $page_background_color ) );
	    }
	
	    $selection_color = tonda_select_options()->getOptionValue( 'selection_color' );
	    if ( ! empty( $selection_color ) ) {
		    echo tonda_select_dynamic_css( '::selection', array( 'background' => $selection_color ) );
		    echo tonda_select_dynamic_css( '::-moz-selection', array( 'background' => $selection_color ) );
	    }
	
	    $preload_background_styles = array();
	
	    if ( tonda_select_options()->getOptionValue( 'preload_pattern_image' ) !== "" ) {
		    $preload_background_styles['background-image'] = 'url(' . tonda_select_options()->getOptionValue( 'preload_pattern_image' ) . ') !important';
	    }
	
	    echo tonda_select_dynamic_css( '.qodef-preload-background', $preload_background_styles );
    }

    add_action('tonda_select_action_style_dynamic', 'tonda_select_design_styles');
}

if ( ! function_exists( 'tonda_select_content_styles' ) ) {
	function tonda_select_content_styles() {
		$content_style = array();
		
		$padding = tonda_select_options()->getOptionValue( 'content_padding' );
		if ( $padding !== '' ) {
			$content_style['padding'] = $padding;
		}
		
		$content_selector = array(
			'.qodef-content .qodef-content-inner > .qodef-full-width > .qodef-full-width-inner',
		);
		
		echo tonda_select_dynamic_css( $content_selector, $content_style );
		
		$content_style_in_grid = array();
		
		$padding_in_grid = tonda_select_options()->getOptionValue( 'content_padding_in_grid' );
		if ( $padding_in_grid !== '' ) {
			$content_style_in_grid['padding'] = $padding_in_grid;
		}
		
		$content_selector_in_grid = array(
			'.qodef-content .qodef-content-inner > .qodef-container > .qodef-container-inner',
		);
		
		echo tonda_select_dynamic_css( $content_selector_in_grid, $content_style_in_grid );
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_content_styles' );
}

if ( ! function_exists( 'tonda_select_h1_styles' ) ) {
	function tonda_select_h1_styles() {
		$margin_top    = tonda_select_options()->getOptionValue( 'h1_margin_top' );
		$margin_bottom = tonda_select_options()->getOptionValue( 'h1_margin_bottom' );
		
		$item_styles = tonda_select_get_typography_styles( 'h1' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = tonda_select_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = tonda_select_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h1'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo tonda_select_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_h1_styles' );
}

if ( ! function_exists( 'tonda_select_h2_styles' ) ) {
	function tonda_select_h2_styles() {
		$margin_top    = tonda_select_options()->getOptionValue( 'h2_margin_top' );
		$margin_bottom = tonda_select_options()->getOptionValue( 'h2_margin_bottom' );
		
		$item_styles = tonda_select_get_typography_styles( 'h2' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = tonda_select_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = tonda_select_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h2'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo tonda_select_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_h2_styles' );
}

if ( ! function_exists( 'tonda_select_h3_styles' ) ) {
	function tonda_select_h3_styles() {
		$margin_top    = tonda_select_options()->getOptionValue( 'h3_margin_top' );
		$margin_bottom = tonda_select_options()->getOptionValue( 'h3_margin_bottom' );
		
		$item_styles = tonda_select_get_typography_styles( 'h3' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = tonda_select_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = tonda_select_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h3'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo tonda_select_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_h3_styles' );
}

if ( ! function_exists( 'tonda_select_h4_styles' ) ) {
	function tonda_select_h4_styles() {
		$margin_top    = tonda_select_options()->getOptionValue( 'h4_margin_top' );
		$margin_bottom = tonda_select_options()->getOptionValue( 'h4_margin_bottom' );
		
		$item_styles = tonda_select_get_typography_styles( 'h4' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = tonda_select_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = tonda_select_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h4'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo tonda_select_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_h4_styles' );
}

if ( ! function_exists( 'tonda_select_h5_styles' ) ) {
	function tonda_select_h5_styles() {
		$margin_top    = tonda_select_options()->getOptionValue( 'h5_margin_top' );
		$margin_bottom = tonda_select_options()->getOptionValue( 'h5_margin_bottom' );
		
		$item_styles = tonda_select_get_typography_styles( 'h5' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = tonda_select_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = tonda_select_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h5'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo tonda_select_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_h5_styles' );
}

if ( ! function_exists( 'tonda_select_h6_styles' ) ) {
	function tonda_select_h6_styles() {
		$margin_top    = tonda_select_options()->getOptionValue( 'h6_margin_top' );
		$margin_bottom = tonda_select_options()->getOptionValue( 'h6_margin_bottom' );
		
		$item_styles = tonda_select_get_typography_styles( 'h6' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = tonda_select_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = tonda_select_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h6'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo tonda_select_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_h6_styles' );
}

if ( ! function_exists( 'tonda_select_text_styles' ) ) {
	function tonda_select_text_styles() {
		$item_styles = tonda_select_get_typography_styles( 'text' );
		
		$item_selector = array(
			'p'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo tonda_select_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_text_styles' );
}

if ( ! function_exists( 'tonda_select_link_styles' ) ) {
	function tonda_select_link_styles() {
		$link_styles      = array();
		$link_color       = tonda_select_options()->getOptionValue( 'link_color' );
		$link_font_style  = tonda_select_options()->getOptionValue( 'link_fontstyle' );
		$link_font_weight = tonda_select_options()->getOptionValue( 'link_fontweight' );
		$link_decoration  = tonda_select_options()->getOptionValue( 'link_fontdecoration' );
		
		if ( ! empty( $link_color ) ) {
			$link_styles['color'] = $link_color;
		}
		if ( ! empty( $link_font_style ) ) {
			$link_styles['font-style'] = $link_font_style;
		}
		if ( ! empty( $link_font_weight ) ) {
			$link_styles['font-weight'] = $link_font_weight;
		}
		if ( ! empty( $link_decoration ) ) {
			$link_styles['text-decoration'] = $link_decoration;
		}
		
		$link_selector = array(
			'a',
			'p a'
		);
		
		if ( ! empty( $link_styles ) ) {
			echo tonda_select_dynamic_css( $link_selector, $link_styles );
		}
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_link_styles' );
}

if ( ! function_exists( 'tonda_select_link_hover_styles' ) ) {
	function tonda_select_link_hover_styles() {
		$link_hover_styles     = array();
		$link_hover_color      = tonda_select_options()->getOptionValue( 'link_hovercolor' );
		$link_hover_decoration = tonda_select_options()->getOptionValue( 'link_hover_fontdecoration' );
		
		if ( ! empty( $link_hover_color ) ) {
			$link_hover_styles['color'] = $link_hover_color;
		}
		if ( ! empty( $link_hover_decoration ) ) {
			$link_hover_styles['text-decoration'] = $link_hover_decoration;
		}
		
		$link_hover_selector = array(
			'a:hover',
			'p a:hover'
		);
		
		if ( ! empty( $link_hover_styles ) ) {
			echo tonda_select_dynamic_css( $link_hover_selector, $link_hover_styles );
		}
		
		$link_heading_hover_styles = array();
		
		if ( ! empty( $link_hover_color ) ) {
			$link_heading_hover_styles['color'] = $link_hover_color;
		}
		
		$link_heading_hover_selector = array(
			'h1 a:hover',
			'h2 a:hover',
			'h3 a:hover',
			'h4 a:hover',
			'h5 a:hover',
			'h6 a:hover'
		);
		
		if ( ! empty( $link_heading_hover_styles ) ) {
			echo tonda_select_dynamic_css( $link_heading_hover_selector, $link_heading_hover_styles );
		}
	}
	
	add_action( 'tonda_select_action_style_dynamic', 'tonda_select_link_hover_styles' );
}

if ( ! function_exists( 'tonda_select_smooth_page_transition_styles' ) ) {
	function tonda_select_smooth_page_transition_styles( $style ) {
		$id            = tonda_select_get_page_id();
		$loader_style  = array();
		$current_style = '';
		
		$background_color = tonda_select_get_meta_field_intersect( 'smooth_pt_bgnd_color', $id );
		if ( ! empty( $background_color ) ) {
			$loader_style['background-color'] = $background_color;
		}
		
		$loader_selector = array(
			'.qodef-smooth-transition-loader'
		);
		
		if ( ! empty( $loader_style ) ) {
			$current_style .= tonda_select_dynamic_css( $loader_selector, $loader_style );
		}
		
		$spinner_style = array();
		$spinner_color = tonda_select_get_meta_field_intersect( 'smooth_pt_spinner_color', $id );
		if ( ! empty( $spinner_color ) ) {
			$spinner_style['background-color'] = $spinner_color;
		}
		
		$spinner_selectors = array(
			'.qodef-st-loader .qodef-rotate-circles > div',
			'.qodef-st-loader .pulse',
			'.qodef-st-loader .double_pulse .double-bounce1',
			'.qodef-st-loader .double_pulse .double-bounce2',
			'.qodef-st-loader .cube',
			'.qodef-st-loader .rotating_cubes .cube1',
			'.qodef-st-loader .rotating_cubes .cube2',
			'.qodef-st-loader .stripes > div',
			'.qodef-st-loader .wave > div',
			'.qodef-st-loader .two_rotating_circles .dot1',
			'.qodef-st-loader .two_rotating_circles .dot2',
			'.qodef-st-loader .five_rotating_circles .container1 > div',
			'.qodef-st-loader .five_rotating_circles .container2 > div',
			'.qodef-st-loader .five_rotating_circles .container3 > div',
			'.qodef-st-loader .atom .ball-1:before',
			'.qodef-st-loader .atom .ball-2:before',
			'.qodef-st-loader .atom .ball-3:before',
			'.qodef-st-loader .atom .ball-4:before',
			'.qodef-st-loader .clock .ball:before',
			'.qodef-st-loader .mitosis .ball',
			'.qodef-st-loader .lines .line1',
			'.qodef-st-loader .lines .line2',
			'.qodef-st-loader .lines .line3',
			'.qodef-st-loader .lines .line4',
			'.qodef-st-loader .fussion .ball',
			'.qodef-st-loader .fussion .ball-1',
			'.qodef-st-loader .fussion .ball-2',
			'.qodef-st-loader .fussion .ball-3',
			'.qodef-st-loader .fussion .ball-4',
			'.qodef-st-loader .wave_circles .ball',
			'.qodef-st-loader .pulse_circles .ball'
		);

		if ( ! empty( $spinner_style ) ) {
			$current_style .= tonda_select_dynamic_css( $spinner_selectors, $spinner_style );
		}

		$spinner_svg_style = array();
		
		if ( ! empty( $spinner_color ) ) {
			$spinner_svg_style['stroke'] = $spinner_color;
		}
		
		$svg_spinner_selectors = array(
			'.qodef-tonda-preloader path'
		);

		if ( ! empty( $spinner_svg_style ) ) {
			$current_style .= tonda_select_dynamic_css( $svg_spinner_selectors, $spinner_svg_style );
		}
		
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'tonda_select_filter_add_page_custom_style', 'tonda_select_smooth_page_transition_styles' );
}