<?php get_header(); ?>
				<div class="qodef-page-not-found">
					<div class="qodef-grid">
						<?php
						$qodef_title_404       = tonda_select_options()->getOptionValue( '404_title' );
						$qodef_text_404        = tonda_select_options()->getOptionValue( '404_text' );
						$qodef_button_label    = tonda_select_options()->getOptionValue( '404_back_to_home' );
						$qodef_button_style    = tonda_select_options()->getOptionValue( '404_button_style' );
						?>
						
						<h1 class="qodef-404-title">
							<?php if ( ! empty( $qodef_title_404 ) ) {
								echo wp_kses( $qodef_title_404, array( 'br' => true ) );
							} else {
								echo wp_kses( sprintf( esc_html__( 'We are %s sorry', 'tonda' ), '<br />' ), array( 'br' => true ) );
							} ?>
						</h1>
						
						<p class="qodef-404-text">
							<?php if ( ! empty( $qodef_text_404 ) ) {
								echo esc_html( $qodef_text_404 );
							} else {
								esc_html_e( 'The page you are looking for does not exist. It may have been moved or deleted.', 'tonda' );
							} ?>
						</p>
						
						<div class="qodef-404-search">
							<h4 class="qodef-404-search-label"><?php esc_html_e( 'Search', 'tonda' ); ?></h4>
							<?php get_search_form(); ?>
						</div>
						
						<?php
						$button_params = array(
							'type' => 'simple',
							'link' => esc_url( home_url( '/' ) ),
							'text' => ! empty( $qodef_button_label ) ? $qodef_button_label : esc_html__( 'Go Back', 'tonda' )
						);
						
						if ( $qodef_button_style == 'light-style' ) {
							$button_params['custom_class'] = 'qodef-btn-light-style';
						}
						
						echo tonda_select_return_button_html( $button_params );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php wp_footer(); ?>
</body>
</html>